/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.service.ClientDiagramService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.command.impl.AbstractExportSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.editor.commons.client.file.exports.TextContent;
import org.uberfire.ext.editor.commons.client.file.exports.TextFileExport;

@Dependent
@Default
public class ExportToBpmnSessionCommand
extends AbstractExportSessionCommand {
    private final ClientDiagramService clientDiagramService;
    private final ErrorPopupPresenter errorPopupPresenter;
    private final TextFileExport textFileExport;

    protected ExportToBpmnSessionCommand() {
        this(null, null, null);
    }

    @Inject
    public ExportToBpmnSessionCommand(ClientDiagramService clientDiagramService, ErrorPopupPresenter errorPopupPresenter, TextFileExport textFileExport) {
        super(true);
        this.clientDiagramService = clientDiagramService;
        this.errorPopupPresenter = errorPopupPresenter;
        this.textFileExport = textFileExport;
    }

    @Override
    protected void export(final String fileName) {
        this.clientDiagramService.getRawContent(((AbstractCanvasHandler)((AbstractSession)this.getSession()).getCanvasHandler()).getDiagram(), new ServiceCallback<String>(){

            public void onSuccess(String rawContent) {
                ExportToBpmnSessionCommand.this.textFileExport.export((Object)TextContent.create((String)rawContent), fileName);
            }

            public void onError(ClientRuntimeError error) {
                ExportToBpmnSessionCommand.this.errorPopupPresenter.showMessage(error.getMessage());
            }
        });
    }
}

