/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Default;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasGrid;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;

@Dependent
@Default
public class SwitchGridSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    public static final CanvasGrid[] GRIDS = new CanvasGrid[]{CanvasGrid.SMALL_POINT_GRID, CanvasGrid.DEFAULT_GRID, CanvasGrid.DRAG_GRID, null};
    private static final byte DEFAULT_GRID_INDEX = 0;
    private byte gridIndex;

    public SwitchGridSessionCommand() {
        super(true);
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        this.resetGrid();
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        this.gridIndex = (byte)(this.gridIndex + 1);
        if (this.gridIndex == GRIDS.length) {
            this.gridIndex = 0;
        }
        this.updateGrid();
        callback.onSuccess();
    }

    @Override
    protected void doDestroy() {
        super.doDestroy();
    }

    private void resetGrid() {
        this.gridIndex = 0;
        this.updateGrid();
    }

    private void updateGrid() {
        ((AbstractCanvas)((EditorSession)this.getSession()).getCanvas()).setGrid(GRIDS[this.gridIndex]);
    }
}

