/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.Objects;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeysMatcher;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasUndoCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;

@Dependent
@Default
public class UndoSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;

    protected UndoSessionCommand() {
        this(null);
    }

    @Inject
    public UndoSessionCommand(@Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager) {
        super(false);
        this.sessionCommandManager = sessionCommandManager;
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        session.getKeyboardControl().addKeyShortcutCallback(this::onKeyDownEvent);
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    void onKeyDownEvent(KeyboardEvent.Key ... keys) {
        if (this.isEnabled()) {
            this.handleCtrlZ(keys);
        }
    }

    private void handleCtrlZ(KeyboardEvent.Key[] keys) {
        if (KeysMatcher.doKeysMatch(keys, KeyboardEvent.Key.CONTROL, KeyboardEvent.Key.Z)) {
            this.execute();
        }
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        SessionCommandManager<AbstractCanvasHandler> scm = this.getSessionCommandManager();
        if (null != scm) {
            CommandResult result = this.getSessionCommandManager().undo((Object)((AbstractCanvasHandler)((EditorSession)this.getSession()).getCanvasHandler()));
            this.checkState();
            if (CommandUtils.isError((CommandResult)result)) {
                callback.onError(result);
            } else {
                callback.onSuccess();
            }
            ((EditorSession)this.getSession()).getSelectionControl().clearSelection();
        }
    }

    void onCommandExecuted(@Observes CanvasCommandExecutedEvent commandExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandExecutedEvent", (Object)commandExecutedEvent);
        this.checkState();
    }

    void onCommandUndoExecuted(@Observes CanvasUndoCommandExecutedEvent commandUndoExecutedEvent) {
        PortablePreconditions.checkNotNull((String)"commandUndoExecutedEvent", (Object)commandUndoExecutedEvent);
        this.checkState();
    }

    void onClearSessionExecuted(@Observes ClearSessionCommandExecutedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (Objects.equals(this.getSession(), event.getClientSession())) {
            this.checkState();
        }
    }

    private void checkState() {
        if (null != this.getSession()) {
            SessionCommandManager<AbstractCanvasHandler> cm = this.getSessionCommandManager();
            boolean isHistoryEmpty = cm == null || cm.getRegistry().getCommandHistory().isEmpty();
            this.setEnabled(!isHistoryEmpty);
        } else {
            this.setEnabled(false);
        }
        this.fire();
    }

    private SessionCommandManager<AbstractCanvasHandler> getSessionCommandManager() {
        return this.sessionCommandManager;
    }
}

