/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.shape.Shape;

public class DefaultCanvasShapeListener
implements CanvasShapeListener {
    private final Iterable<CanvasControl<AbstractCanvas>> canvasControls;

    public DefaultCanvasShapeListener(Iterable<CanvasControl<AbstractCanvas>> canvasControls) {
        this.canvasControls = canvasControls;
    }

    public void register(Shape item) {
        this.onRegisterShape(item);
    }

    public void deregister(Shape item) {
        this.onDeregisterShape(item);
    }

    public void clear() {
        this.onClear();
    }

    private void onRegisterShape(Shape shape) {
        this.onShapeRegistration(shape, true);
    }

    private void onDeregisterShape(Shape shape) {
        this.onShapeRegistration(shape, false);
    }

    private void onShapeRegistration(Shape shape, boolean add) {
        this.canvasControls.forEach(c -> this.fireRegistrationListeners((CanvasControl<AbstractCanvas>)c, shape, add));
    }

    private void fireRegistrationListeners(CanvasControl<AbstractCanvas> control, Shape shape, boolean add) {
        if (null != shape && control instanceof CanvasRegistrationControl) {
            CanvasRegistrationControl registrationControl = (CanvasRegistrationControl)control;
            if (add) {
                registrationControl.register((Object)shape);
            } else {
                registrationControl.deregister((Object)shape);
            }
        }
    }

    private void onClear() {
        this.canvasControls.forEach(this::fireRegistrationClearListeners);
    }

    private void fireRegistrationClearListeners(CanvasControl<AbstractCanvas> control) {
        if (control instanceof CanvasRegistrationControl) {
            CanvasRegistrationControl registrationControl = (CanvasRegistrationControl)control;
            registrationControl.clear();
        }
    }
}

