/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CanvasInPlaceTextEditorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.MultiLineTextEditorBox;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.EdgeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.NodeBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.Observer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.clipboard.ClipboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ConnectionAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.connection.ControlPointControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.containment.ContainmentAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.docking.DockingAcceptorControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.drag.LocationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.AbstractCanvasShortcutsControlImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.keyboard.KeyboardControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.pan.PanControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.resize.ResizeControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.MultipleSelection;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.zoom.ZoomControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.Request;
import org.kie.workbench.common.stunner.core.client.command.RequiresCommandManager;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.preferences.StunnerPreferencesRegistry;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.client.session.impl.ManagedSession;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.registry.RegistryFactory;
import org.kie.workbench.common.stunner.core.registry.command.CommandRegistry;
import org.uberfire.mvp.Command;

@Dependent
public class DefaultEditorSession
extends EditorSession {
    private final ManagedSession session;
    private final CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final SessionCommandManager<AbstractCanvasHandler> requestCommandManager;
    private final StunnerPreferencesRegistry stunnerPreferencesRegistry;
    private final CommandRegistry<org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation>> commandRegistry;

    @Inject
    public DefaultEditorSession(ManagedSession session, RegistryFactory registryFactory, CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, @Request SessionCommandManager<AbstractCanvasHandler> requestCommandManager, StunnerPreferencesRegistry stunnerPreferencesRegistry) {
        this.session = session;
        this.commandRegistry = registryFactory.newCommandRegistry();
        this.sessionCommandManager = sessionCommandManager;
        this.requestCommandManager = requestCommandManager;
        this.canvasCommandManager = canvasCommandManager;
        this.stunnerPreferencesRegistry = stunnerPreferencesRegistry;
    }

    @PostConstruct
    public void constructInstance() {
        this.session.onCanvasControlRegistered(this::onControlRegistered).onCanvasHandlerControlRegistered(this::onCanvasHandlerControlRegistered).onCanvasControlDestroyed(AbstractSession::onControlDestroyed).onCanvasHandlerControlDestroyed(AbstractSession::onControlDestroyed);
    }

    @Override
    public void init(Metadata metadata, Command callback) {
        this.init(s -> s.registerCanvasControl(ZoomControl.class).registerCanvasControl(PanControl.class).registerCanvasHandlerControl(SelectionControl.class, MultipleSelection.class).registerCanvasHandlerControl(ResizeControl.class).registerCanvasHandlerControl(ConnectionAcceptorControl.class).registerCanvasHandlerControl(ContainmentAcceptorControl.class).registerCanvasHandlerControl(DockingAcceptorControl.class).registerCanvasHandlerControl(CanvasInPlaceTextEditorControl.class, MultiLineTextEditorBox.class).registerCanvasHandlerControl(LocationControl.class).registerCanvasHandlerControl(ToolboxControl.class).registerCanvasHandlerControl(ElementBuilderControl.class, Observer.class).registerCanvasHandlerControl(NodeBuilderControl.class).registerCanvasHandlerControl(EdgeBuilderControl.class).registerCanvasHandlerControl(AbstractCanvasShortcutsControlImpl.class).registerCanvasControl(KeyboardControl.class).registerCanvasControl(ClipboardControl.class).registerCanvasHandlerControl(ControlPointControl.class), metadata, callback);
    }

    public void init(Consumer<ManagedSession> sessionControls, Metadata metadata, Command callback) {
        sessionControls.accept(this.session);
        this.session.init(metadata, callback);
    }

    @Override
    public void open() {
        this.session.open();
    }

    @Override
    public void destroy() {
        this.commandRegistry.clear();
        this.session.destroy();
    }

    protected ManagedSession getSession() {
        return this.session;
    }

    public String getSessionUUID() {
        return this.session.getSessionUUID();
    }

    public AbstractCanvas getCanvas() {
        return this.session.getCanvas();
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.session.getCanvasHandler();
    }

    @Override
    public CanvasCommandManager<AbstractCanvasHandler> getCommandManager() {
        return this.canvasCommandManager;
    }

    @Override
    public CommandRegistry<org.kie.workbench.common.stunner.core.command.Command<AbstractCanvasHandler, CanvasViolation>> getCommandRegistry() {
        return this.commandRegistry;
    }

    @Override
    public ZoomControl<AbstractCanvas> getZoomControl() {
        return (ZoomControl)this.session.getCanvasControl(ZoomControl.class);
    }

    @Override
    public PanControl<AbstractCanvas> getPanControl() {
        return (PanControl)this.session.getCanvasControl(PanControl.class);
    }

    @Override
    public KeyboardControl<AbstractCanvas, ClientSession> getKeyboardControl() {
        return (KeyboardControl)this.session.getCanvasControl(KeyboardControl.class);
    }

    @Override
    public ClipboardControl<Element, AbstractCanvas, ClientSession> getClipboardControl() {
        return (ClipboardControl)this.session.getCanvasControl(ClipboardControl.class);
    }

    @Override
    public SelectionControl<AbstractCanvasHandler, Element> getSelectionControl() {
        return (SelectionControl)this.session.getCanvasHandlerControl(SelectionControl.class);
    }

    @Override
    public ConnectionAcceptorControl<AbstractCanvasHandler> getConnectionAcceptorControl() {
        return (ConnectionAcceptorControl)this.session.getCanvasHandlerControl(ConnectionAcceptorControl.class);
    }

    @Override
    public ContainmentAcceptorControl<AbstractCanvasHandler> getContainmentAcceptorControl() {
        return (ContainmentAcceptorControl)this.session.getCanvasHandlerControl(ContainmentAcceptorControl.class);
    }

    @Override
    public DockingAcceptorControl<AbstractCanvasHandler> getDockingAcceptorControl() {
        return (DockingAcceptorControl)this.session.getCanvasHandlerControl(DockingAcceptorControl.class);
    }

    private void onCanvasHandlerControlRegistered(CanvasControl<AbstractCanvasHandler> control) {
        if (control instanceof RequiresCommandManager) {
            if (control instanceof LocationControl || control instanceof ConnectionAcceptorControl || control instanceof ControlPointControl || control instanceof DockingAcceptorControl || control instanceof ContainmentAcceptorControl) {
                ((RequiresCommandManager)control).setCommandManagerProvider(() -> this.requestCommandManager);
            } else {
                ((RequiresCommandManager)control).setCommandManagerProvider(() -> this.sessionCommandManager);
            }
        }
        this.onControlRegistered(control);
    }
}

