/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import com.google.gwt.logging.client.LogConfiguration;
import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasControl;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.client.session.impl.DefaultCanvasElementListener;
import org.kie.workbench.common.stunner.core.client.session.impl.DefaultCanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.client.session.impl.SessionLoader;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.preferences.StunnerPreferences;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.UUID;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class ManagedSession
extends AbstractSession<AbstractCanvas, AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(ManagedSession.class.getName());
    private final DefinitionUtils definitionUtils;
    private final SessionLoader sessionLoader;
    private final ManagedInstance<AbstractCanvas> canvasInstances;
    private final ManagedInstance<AbstractCanvasHandler> canvasHandlerInstances;
    private final ManagedInstance<CanvasControl<AbstractCanvas>> canvasControlInstances;
    private final ManagedInstance<CanvasControl<AbstractCanvasHandler>> canvasHandlerControlInstances;
    private final String uuid;
    private AbstractCanvas canvas;
    private AbstractCanvasHandler canvasHandler;
    private final List<ControlRegistrationEntry<AbstractCanvas>> canvasControlRegistrationEntries;
    private final List<ControlRegistrationEntry<AbstractCanvasHandler>> canvasHandlerControlRegistrationEntries;
    private final List<Class<? extends CanvasControl>> canvasControlTypes;
    private final List<CanvasControl<AbstractCanvas>> canvasControls;
    private final List<Class<? extends CanvasControl>> canvasHandlerControlTypes;
    private final List<CanvasControl<AbstractCanvasHandler>> canvasHandlerControls;
    private Predicate<Class<? extends CanvasControl>> controlActivePredicate;
    private CanvasShapeListener shapeListener;
    private CanvasElementListener elementListener;
    private Consumer<CanvasControl<AbstractCanvas>> canvasControlRegistered;
    private Consumer<CanvasControl<AbstractCanvas>> canvasControlDestroyed;
    private Consumer<CanvasControl<AbstractCanvasHandler>> canvasHandlerControlRegistered;
    private Consumer<CanvasControl<AbstractCanvasHandler>> canvasHandlerControlDestroyed;

    @Inject
    public ManagedSession(DefinitionUtils definitionUtils, SessionLoader sessionLoader, @Any ManagedInstance<AbstractCanvas> canvasInstances, @Any ManagedInstance<AbstractCanvasHandler> canvasHandlerInstances, @Any ManagedInstance<CanvasControl<AbstractCanvas>> canvasControlInstances, @Any ManagedInstance<CanvasControl<AbstractCanvasHandler>> canvasHandlerControlInstances) {
        this.definitionUtils = definitionUtils;
        this.sessionLoader = sessionLoader;
        this.uuid = UUID.uuid();
        this.canvasInstances = canvasInstances;
        this.canvasHandlerInstances = canvasHandlerInstances;
        this.canvasControlInstances = canvasControlInstances;
        this.canvasHandlerControlInstances = canvasHandlerControlInstances;
        this.canvasControlRegistrationEntries = new LinkedList<ControlRegistrationEntry<AbstractCanvas>>();
        this.canvasHandlerControlRegistrationEntries = new LinkedList<ControlRegistrationEntry<AbstractCanvasHandler>>();
        this.canvasControls = new LinkedList<CanvasControl<AbstractCanvas>>();
        this.canvasControlTypes = new LinkedList<Class<? extends CanvasControl>>();
        this.canvasHandlerControls = new LinkedList<CanvasControl<AbstractCanvasHandler>>();
        this.canvasHandlerControlTypes = new LinkedList<Class<? extends CanvasControl>>();
        this.canvasControlRegistered = c -> {};
        this.canvasHandlerControlRegistered = c -> {};
        this.canvasControlDestroyed = c -> {};
        this.canvasHandlerControlDestroyed = c -> {};
        this.controlActivePredicate = type -> true;
    }

    public ManagedSession registerCanvasControl(Class<? extends CanvasControl> type) {
        return this.registerCanvasControl(type, null);
    }

    public ManagedSession registerCanvasControl(Class<? extends CanvasControl> type, Class<? extends Annotation> qualifier) {
        this.canvasControlRegistrationEntries.add(new ControlRegistrationEntry(type, null != qualifier ? ManagedSession.buildQualifier(qualifier) : null));
        return this;
    }

    public ManagedSession registerCanvasHandlerControl(Class<? extends CanvasControl> type) {
        return this.registerCanvasHandlerControl(type, null);
    }

    public ManagedSession registerCanvasHandlerControl(Class<? extends CanvasControl> type, Class<? extends Annotation> qualifier) {
        this.canvasHandlerControlRegistrationEntries.add(new ControlRegistrationEntry(type, null != qualifier ? ManagedSession.buildQualifier(qualifier) : null));
        return this;
    }

    public ManagedSession isControlActive(Predicate<Class<? extends CanvasControl>> predicate) {
        this.controlActivePredicate = predicate;
        return this;
    }

    public ManagedSession onCanvasControlRegistered(Consumer<CanvasControl<AbstractCanvas>> c) {
        this.canvasControlRegistered = c;
        return this;
    }

    public ManagedSession onCanvasControlDestroyed(Consumer<CanvasControl<AbstractCanvas>> c) {
        this.canvasControlDestroyed = c;
        return this;
    }

    public ManagedSession onCanvasHandlerControlRegistered(Consumer<CanvasControl<AbstractCanvasHandler>> c) {
        this.canvasHandlerControlRegistered = c;
        return this;
    }

    public ManagedSession onCanvasHandlerControlDestroyed(Consumer<CanvasControl<AbstractCanvasHandler>> c) {
        this.canvasHandlerControlDestroyed = c;
        return this;
    }

    @Override
    public void init(Metadata metadata, Command callback) {
        if (null != this.canvas) {
            throw new IllegalStateException("Session is already loaded!");
        }
        this.sessionLoader.load(metadata, (ParameterizedCommand<StunnerPreferences>)((ParameterizedCommand)prefs -> {
            Annotation qualifier = this.definitionUtils.getQualifier(metadata.getDefinitionSetId());
            this.canvas = InstanceUtils.lookup(this.canvasInstances, qualifier);
            this.canvasHandler = InstanceUtils.lookup(this.canvasHandlerInstances, qualifier);
            this.canvasControlRegistrationEntries.forEach(entry -> this.registerCanvasControlEntry((ControlRegistrationEntry<AbstractCanvas>)entry, qualifier));
            this.canvasHandlerControlRegistrationEntries.forEach(entry -> this.registerCanvasHandlerControlEntry((ControlRegistrationEntry<AbstractCanvasHandler>)entry, qualifier));
            callback.execute();
        }), (ParameterizedCommand<Throwable>)((ParameterizedCommand)throwable -> {
            if (LogConfiguration.loggingIsEnabled()) {
                LOGGER.log(Level.SEVERE, "An error was produced during StunnerPreferences initialization.", (Throwable)throwable);
            }
            throw new RuntimeException((Throwable)throwable);
        }));
    }

    @Override
    public void open() {
        if (null == this.shapeListener) {
            this.shapeListener = new DefaultCanvasShapeListener(this.canvasControls);
            this.elementListener = new DefaultCanvasElementListener(this.canvasHandlerControls);
            this.registerListeners();
            this.enableControls();
        }
    }

    @Override
    public void destroy() {
        this.sessionLoader.destroy();
        this.removeListeners();
        this.canvasControls.forEach(this::destroyCanvasControl);
        this.canvasControls.clear();
        this.canvasControlTypes.clear();
        this.canvasHandlerControls.forEach(this::destroyCanvasHandlerControl);
        this.canvasHandlerControls.clear();
        this.canvasHandlerControlTypes.clear();
        this.canvasControlInstances.destroyAll();
        this.canvasHandlerControlInstances.destroyAll();
        this.canvasHandler.destroy();
        this.canvasInstances.destroyAll();
        this.canvasHandlerInstances.destroyAll();
        this.canvas = null;
        this.canvasHandler = null;
        this.shapeListener = null;
        this.elementListener = null;
        this.canvasControlRegistered = null;
        this.canvasControlDestroyed = null;
        this.canvasHandlerControlRegistered = null;
        this.canvasHandlerControlDestroyed = null;
    }

    public String getSessionUUID() {
        return this.uuid;
    }

    public AbstractCanvas getCanvas() {
        return this.canvas;
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    public CanvasControl<AbstractCanvas> getCanvasControl(Class<? extends CanvasControl> type) {
        int i = this.canvasControlTypes.indexOf(type);
        if (i > -1) {
            return this.canvasControls.get(i);
        }
        return null;
    }

    public CanvasControl<AbstractCanvasHandler> getCanvasHandlerControl(Class<? extends CanvasControl> type) {
        int i = this.canvasHandlerControlTypes.indexOf(type);
        if (i > -1) {
            return this.canvasHandlerControls.get(i);
        }
        return null;
    }

    public static Annotation buildQualifier(final Class<? extends Annotation> type) {
        return new Default(){

            public Class<? extends Annotation> annotationType() {
                return type;
            }
        };
    }

    private void registerListeners() {
        this.canvas.addRegistrationListener(this.shapeListener);
        this.canvasHandler.addRegistrationListener(this.elementListener);
    }

    private void removeListeners() {
        this.canvas.removeRegistrationListener(this.shapeListener);
        this.canvasHandler.removeRegistrationListener(this.elementListener);
    }

    private void enableControls() {
        this.canvasControls.forEach(c -> c.init((Object)this.canvas));
        this.canvasHandlerControls.forEach(c -> c.init((Object)this.canvasHandler));
    }

    private void registerCanvasControlEntry(ControlRegistrationEntry<AbstractCanvas> entry, Annotation qualifier) {
        if (this.isControlActive(((ControlRegistrationEntry)entry).type)) {
            this.registerCanvasControl(entry, ManagedSession.lookupCanvasControl(this.canvasControlInstances, entry, qualifier));
        }
    }

    private void registerCanvasControl(ControlRegistrationEntry<AbstractCanvas> entry, CanvasControl<AbstractCanvas> control) {
        this.canvasControlTypes.add(((ControlRegistrationEntry)entry).type);
        this.canvasControls.add(control);
        this.canvasControlRegistered.accept(control);
    }

    private void registerCanvasHandlerControlEntry(ControlRegistrationEntry<AbstractCanvasHandler> entry, Annotation qualifier) {
        if (this.isControlActive(((ControlRegistrationEntry)entry).type)) {
            this.registerCanvasHandlerControl(entry, ManagedSession.lookupCanvasHandlerControl(this.canvasHandlerControlInstances, entry, qualifier));
        }
    }

    private void registerCanvasHandlerControl(ControlRegistrationEntry<AbstractCanvasHandler> entry, CanvasControl<AbstractCanvasHandler> control) {
        this.canvasHandlerControlTypes.add(((ControlRegistrationEntry)entry).type);
        this.canvasHandlerControls.add(control);
        this.canvasHandlerControlRegistered.accept(control);
    }

    private void destroyCanvasControl(CanvasControl<AbstractCanvas> control) {
        control.destroy();
        this.canvasControlDestroyed.accept(control);
    }

    private void destroyCanvasHandlerControl(CanvasControl<AbstractCanvasHandler> control) {
        control.destroy();
        this.canvasHandlerControlDestroyed.accept(control);
    }

    private static CanvasControl<AbstractCanvasHandler> lookupCanvasHandlerControl(ManagedInstance instance, ControlRegistrationEntry<AbstractCanvasHandler> entry, Annotation qualifier) {
        return (CanvasControl)ManagedSession.doLookup(instance, entry, qualifier);
    }

    private static CanvasControl<AbstractCanvas> lookupCanvasControl(ManagedInstance instance, ControlRegistrationEntry<AbstractCanvas> entry, Annotation qualifier) {
        return (CanvasControl)ManagedSession.doLookup(instance, entry, qualifier);
    }

    private static Object doLookup(ManagedInstance instance, ControlRegistrationEntry entry, Annotation qualifier) {
        ManagedInstance i;
        ManagedInstance managedInstance = i = null != entry.qualifier ? instance.select(entry.type, new Annotation[]{entry.qualifier, qualifier}) : instance.select(entry.type, new Annotation[]{qualifier});
        return i.isUnsatisfied() ? (null != entry.qualifier ? instance.select(entry.type, new Annotation[]{entry.qualifier, DefinitionManager.DEFAULT_QUALIFIER}).get() : instance.select(entry.type, new Annotation[]{DefinitionManager.DEFAULT_QUALIFIER}).get()) : i.get();
    }

    private boolean isControlActive(Class<? extends CanvasControl> type) {
        return this.controlActivePredicate.test(type);
    }

    List<CanvasControl<AbstractCanvas>> getCanvasControls() {
        return this.canvasControls;
    }

    List<CanvasControl<AbstractCanvasHandler>> getCanvasHandlerControls() {
        return this.canvasHandlerControls;
    }

    private static class ControlRegistrationEntry<T> {
        private final Class<? extends CanvasControl<T>> type;
        private final Annotation qualifier;

        private ControlRegistrationEntry(Class<? extends CanvasControl<T>> type, Annotation qualifier) {
            this.type = type;
            this.qualifier = qualifier;
        }
    }
}

