/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.impl;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.preferences.StunnerPreferencesRegistryLoader;
import org.kie.workbench.common.stunner.core.client.session.impl.SessionInitializer;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.preferences.StunnerPreferences;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

@Dependent
public class SessionLoader {
    private final DefinitionUtils definitionUtils;
    private final StunnerPreferencesRegistryLoader preferencesRegistryLoader;
    private final ManagedInstance<SessionInitializer> initializerInstances;
    private final List<SessionInitializer> initializers;

    @Inject
    public SessionLoader(DefinitionUtils definitionUtils, StunnerPreferencesRegistryLoader preferencesRegistryLoader, @Any ManagedInstance<SessionInitializer> beanInstances) {
        this.definitionUtils = definitionUtils;
        this.preferencesRegistryLoader = preferencesRegistryLoader;
        this.initializerInstances = beanInstances;
        this.initializers = new LinkedList<SessionInitializer>();
    }

    public void load(Metadata metadata, ParameterizedCommand<StunnerPreferences> completeCallback, ParameterizedCommand<Throwable> errorCallback) {
        String definitionSetId = metadata.getDefinitionSetId();
        Annotation qualifier = this.definitionUtils.getQualifier(definitionSetId);
        this.preferencesRegistryLoader.load(definitionSetId, (ParameterizedCommand<StunnerPreferences>)((ParameterizedCommand)prefs -> this.loadInitializers(metadata, qualifier, () -> completeCallback.execute(prefs))), errorCallback);
    }

    public void destroy() {
        this.initializers.forEach(SessionInitializer::destroy);
        this.initializers.clear();
        this.initializerInstances.destroyAll();
    }

    private void loadInitializers(Metadata metadata, Annotation qualifier, Command callback) {
        this.initializerInstances.select(new Annotation[]{DefinitionManager.DEFAULT_QUALIFIER}).forEach(this.initializers::add);
        this.initializerInstances.select(new Annotation[]{qualifier}).forEach(this.initializers::add);
        this.loadInitializer(metadata, 0, callback);
    }

    private void loadInitializer(Metadata metadata, int index, Command callback) {
        if (index < this.initializers.size()) {
            SessionInitializer bean = this.initializers.get(index);
            bean.init(metadata, () -> this.loadInitializer(metadata, index + 1, callback));
        } else {
            callback.execute();
        }
    }

    List<SessionInitializer> getInitializers() {
        return this.initializers;
    }
}

