/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape;

import com.google.gwt.safehtml.shared.SafeUri;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;

public final class SvgDataUriGlyph
implements Glyph {
    private final SafeUri uri;
    private final Collection<SafeUri> defUris;
    private final Collection<String> validUseRefIds;

    private SvgDataUriGlyph(SafeUri uri, Optional<Collection<SafeUri>> defUris, Optional<Collection<String>> validUseRefIds) {
        this.uri = uri;
        this.defUris = defUris.orElse(Collections.EMPTY_LIST);
        this.validUseRefIds = validUseRefIds.orElse(Collections.EMPTY_LIST);
    }

    public SafeUri getSvg() {
        return this.uri;
    }

    public Collection<SafeUri> getDefs() {
        return this.defUris;
    }

    public Collection<String> getValidUseRefIds() {
        return this.validUseRefIds;
    }

    public static class Builder {
        private SafeUri mainUri;
        private final Map<String, SafeUri> useRefIds;

        public static Builder create() {
            return new Builder(new HashMap<String, SafeUri>());
        }

        private Builder(Map<String, SafeUri> useRefIds) {
            this.useRefIds = useRefIds;
        }

        public Builder setUri(SafeUri uri) {
            this.mainUri = uri;
            return this;
        }

        public Builder addUri(String useRefId, SafeUri uri) {
            if (null != uri) {
                this.useRefIds.put(useRefId, uri);
            }
            return this;
        }

        public SvgDataUriGlyph build(String refId) {
            assert (null != this.mainUri);
            SafeUri safeUri = this.useRefIds.get(refId);
            return null != safeUri ? new SvgDataUriGlyph(this.mainUri, Optional.of(Arrays.asList(safeUri)), Optional.of(Arrays.asList(refId))) : new SvgDataUriGlyph(this.mainUri, Optional.empty(), Optional.empty());
        }

        public SvgDataUriGlyph build() {
            assert (null != this.mainUri);
            return new SvgDataUriGlyph(this.mainUri, this.useRefIds.isEmpty() ? Optional.empty() : Optional.of(this.useRefIds.values()), this.useRefIds.isEmpty() ? Optional.empty() : Optional.of(this.useRefIds.keySet()));
        }

        public static SvgDataUriGlyph build(SafeUri uri) {
            return Builder.create().setUri(uri).build();
        }
    }
}

