/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.factory;

import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.AbstractShapeFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.core.util.DefinitionIdMap;

@Dependent
public class DelegateShapeFactory<W, S extends Shape>
extends AbstractShapeFactory<W, S> {
    private final DefinitionIdMap<DefinitionTypeBindings> definitionTypeBindings = new DefinitionIdMap();

    public DelegateShapeFactory<W, S> delegate(Class<? extends W> definitionType, ShapeDef<? extends W> shapeDef, Supplier<? extends ShapeDefFactory> factory) {
        this.definitionTypeBindings.put(definitionType, (Object)new DefinitionTypeBindings(definitionType, shapeDef, factory));
        return this;
    }

    public S newShape(W definition) {
        DefinitionTypeBindings bindings = this.getBindings(definition.getClass());
        ShapeDef shapeDef = bindings.shapeDef;
        return (S)bindings.factory.get().newShape(definition, shapeDef);
    }

    @PreDestroy
    public void destroy() {
        this.definitionTypeBindings.clear();
    }

    @Override
    protected Glyph getGlyphFor(String definitionId) {
        DefinitionTypeBindings bindings = (DefinitionTypeBindings)this.definitionTypeBindings.get(definitionId);
        Class<?> defType = bindings.defType;
        return bindings.shapeDef.getGlyph(defType, definitionId);
    }

    @Override
    protected Glyph getGlyphFor(String definitionId, Class<? extends ShapeFactory.GlyphConsumer> consumer) {
        DefinitionTypeBindings bindings = (DefinitionTypeBindings)this.definitionTypeBindings.get(definitionId);
        Class<?> defType = bindings.defType;
        return bindings.shapeDef.getGlyph(defType, consumer, definitionId);
    }

    private DefinitionTypeBindings getBindings(Class<?> type) {
        DefinitionTypeBindings bindings = (DefinitionTypeBindings)this.definitionTypeBindings.get(type);
        if (null == bindings) {
            throw new RuntimeException("No ShapeDefinition or ShapeFactory binding found for the Definition type [" + type + "]");
        }
        return bindings;
    }

    private class DefinitionTypeBindings {
        final Class<?> defType;
        final ShapeDef<? extends W> shapeDef;
        final Supplier<? extends ShapeDefFactory> factory;

        private DefinitionTypeBindings(Class<?> defType, ShapeDef<? extends W> shapeDef, Supplier<? extends ShapeDefFactory> factory) {
            this.defType = defType;
            this.shapeDef = shapeDef;
            this.factory = factory;
        }
    }
}

