/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.factory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFactory;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;

@Dependent
public class ShapeDefFunctionalFactory<W, D extends ShapeDef, S extends Shape>
implements ShapeDefFactory<W, D, S> {
    private final Map<Class<?>, BiFunction<W, D, S>> shapeBuilders = new HashMap();

    public ShapeDefFunctionalFactory<W, D, S> set(Class<? extends D> shapeDefType, BiFunction<W, D, S> shapeBuilderFunction) {
        this.shapeBuilders.put(shapeDefType, shapeBuilderFunction);
        return this;
    }

    public S newShape(W instance, D shapeDef) {
        return this.newShape(instance, shapeDef, shapeDef.getType());
    }

    @PreDestroy
    public void destroy() {
        this.shapeBuilders.clear();
    }

    protected S newShape(W instance, D shapeDef, Class<? extends D> shapeDefType) {
        return (S)((Shape)this.getShapeBuilder(shapeDefType).apply(instance, shapeDef));
    }

    private BiFunction<W, D, S> getShapeBuilder(Class<? extends D> shapeDefType) {
        BiFunction<W, D, S> builder = this.shapeBuilders.get(shapeDefType);
        if (null == builder) {
            throw new RuntimeException("No builder function specified for Shape Definition type [" + shapeDefType.getName() + "]");
        }
        return builder;
    }
}

