/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import org.kie.workbench.common.stunner.core.client.shape.ElementShape;
import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.AbstractShape;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeViewHandlersDef;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeViewDef;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public abstract class AbstractElementShape<W, C extends View<W>, E extends Element<C>, D extends ShapeViewDef<W, V>, V extends ShapeView>
implements ElementShape<W, C, E, V>,
Lifecycle {
    private final ShapeViewHandlersDef<W, V, D> shapeHandlersDef;

    protected AbstractElementShape(D shapeDef) {
        this.shapeHandlersDef = new ShapeViewHandlersDef(shapeDef);
    }

    protected abstract AbstractShape<V> getShape();

    public void setUUID(String uuid) {
        this.getShape().setUUID(uuid);
    }

    public String getUUID() {
        return this.getShape().getUUID();
    }

    public void applyTitle(String title, E element, MutationContext mutationContext) {
        this.getShapeHandlersDef().titleHandler().ifPresent(h -> h.accept(title, this.getShapeView()));
        this.getShapeHandlersDef().fontHandler().ifPresent(h -> h.accept(this.getDefinition((Element<? extends View<W>>)element), this.getShapeView()));
    }

    public void beforeDraw() {
        this.getShape().beforeDraw();
    }

    public void afterDraw() {
        this.getShape().afterDraw();
    }

    public void applyProperties(E element, MutationContext mutationContext) {
        ShapeState shapeState = this.getShape().getShapeStateHandler().reset();
        this.getShapeHandlersDef().viewHandler().accept(this.getDefinition((Element<? extends View<W>>)element), this.getShapeView());
        this.applyCustomProperties(element, mutationContext);
        this.getShapeHandlersDef().sizeHandler().ifPresent(h -> h.accept(element.getContent(), this.getShapeView()));
        this.getShape().getShapeStateHandler().shapeAttributesChanged().applyState(shapeState);
    }

    protected void applyCustomProperties(E element, MutationContext mutationContext) {
    }

    public V getShapeView() {
        return (V)this.getShape().getShapeView();
    }

    public void destroy() {
        this.getShape().destroy();
    }

    public ShapeViewHandlersDef<W, V, D> getShapeHandlersDef() {
        return this.shapeHandlersDef;
    }

    public D getShapeDefinition() {
        return this.getShapeHandlersDef().getShapeViewDef();
    }

    protected W getDefinition(Element<? extends View<W>> element) {
        return (W)((View)element.getContent()).getDefinition();
    }
}

