/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.event.Event;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasGrid;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasPanel;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasSettings;
import org.kie.workbench.common.stunner.core.client.canvas.Transform;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasDrawnEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasShapeListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.HasCanvasListeners;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class AbstractCanvas<V extends CanvasView>
implements Canvas<Shape>,
HasEventHandlers<AbstractCanvas<V>, Shape<?>>,
HasCanvasListeners<CanvasShapeListener> {
    protected CanvasGrid grid;
    protected Event<CanvasClearEvent> canvasClearEvent;
    protected Event<CanvasShapeAddedEvent> canvasShapeAddedEvent;
    protected Event<CanvasShapeRemovedEvent> canvasShapeRemovedEvent;
    protected Event<CanvasDrawnEvent> canvasDrawnEvent;
    protected Event<CanvasFocusedEvent> canvasFocusedEvent;
    private final String uuid;
    protected final Map<String, Shape> shapes = new HashMap<String, Shape>();
    protected final List<CanvasShapeListener> listeners = new LinkedList<CanvasShapeListener>();

    protected AbstractCanvas(Event<CanvasClearEvent> canvasClearEvent, Event<CanvasShapeAddedEvent> canvasShapeAddedEvent, Event<CanvasShapeRemovedEvent> canvasShapeRemovedEvent, Event<CanvasDrawnEvent> canvasDrawnEvent, Event<CanvasFocusedEvent> canvasFocusedEvent) {
        this.canvasClearEvent = canvasClearEvent;
        this.canvasShapeAddedEvent = canvasShapeAddedEvent;
        this.canvasShapeRemovedEvent = canvasShapeRemovedEvent;
        this.canvasDrawnEvent = canvasDrawnEvent;
        this.canvasFocusedEvent = canvasFocusedEvent;
        this.uuid = UUID.uuid();
    }

    public abstract V getView();

    public AbstractCanvas<V> initialize(CanvasPanel panel, CanvasSettings settings) {
        this.onAfterDraw(this::afterDrawCanvas);
        this.getView().initialize(panel, settings);
        return this;
    }

    public Collection<Shape> getShapes() {
        return this.shapes.values();
    }

    public Shape getShape(String uuid) {
        return this.shapes.get(uuid);
    }

    protected abstract void addChild(Shape var1);

    public Canvas addChild(Shape parent, Shape child) {
        this.getView().addChild(parent.getShapeView(), child.getShapeView());
        return this;
    }

    protected abstract void deleteChild(Shape var1);

    public Canvas deleteChild(Shape parent, Shape child) {
        this.getView().deleteChild(parent.getShapeView(), child.getShapeView());
        return this;
    }

    public Canvas dock(Shape parent, Shape child) {
        this.getView().dock(parent.getShapeView(), child.getShapeView());
        return this;
    }

    public Canvas undock(Shape target, Shape child) {
        this.getView().undock(target.getShapeView(), child.getShapeView());
        return this;
    }

    public Canvas addShape(Shape shape) {
        this.shapes.computeIfAbsent(shape.getUUID(), v -> {
            this.addTransientShape(shape);
            this.fireCanvasShapeAdded(shape);
            this.canvasShapeAddedEvent.fire((Object)new CanvasShapeAddedEvent((Canvas)this, shape));
            return shape;
        });
        return this;
    }

    public Canvas addTransientShape(Shape shape) {
        if (shape.getUUID() == null) {
            shape.setUUID(UUID.uuid());
        }
        shape.getShapeView().setUUID(shape.getUUID());
        this.getView().add(shape.getShapeView());
        return this;
    }

    public Canvas deleteShape(Shape shape) {
        this.deleteTransientShape(shape);
        this.fireCanvasShapeRemoved(shape);
        this.shapes.remove(shape.getUUID());
        this.canvasShapeRemovedEvent.fire((Object)new CanvasShapeRemovedEvent((Canvas)this, shape));
        return this;
    }

    public Canvas deleteTransientShape(Shape shape) {
        this.getView().delete(shape.getShapeView());
        shape.destroy();
        return this;
    }

    public AbstractCanvas clear() {
        return this.clear(true);
    }

    private AbstractCanvas clear(boolean fireEvents) {
        this.clearShapes();
        this.fireCanvasClear();
        if (fireEvents) {
            this.canvasClearEvent.fire((Object)new CanvasClearEvent((Canvas)this));
        }
        this.getView().clear();
        return this;
    }

    protected void clearShapes() {
        if (!this.shapes.isEmpty()) {
            this.shapes.values().stream().collect(Collectors.toList()).forEach(this::deleteShape);
            this.shapes.clear();
        }
    }

    public Canvas setGrid(CanvasGrid grid) {
        this.grid = grid;
        this.getView().setGrid(grid);
        return this;
    }

    public CanvasGrid getGrid() {
        return this.grid;
    }

    public Point2D getAbsoluteLocation() {
        return this.getView().getAbsoluteLocation();
    }

    public Transform getTransform() {
        return this.getView().getTransform();
    }

    public void destroy() {
        this.clear(false);
        this.listeners.clear();
        this.getView().destroy();
    }

    public HasCanvasListeners<CanvasShapeListener> addRegistrationListener(CanvasShapeListener instance) {
        this.listeners.add(instance);
        return this;
    }

    public HasCanvasListeners<CanvasShapeListener> removeRegistrationListener(CanvasShapeListener instance) {
        this.listeners.remove(instance);
        return this;
    }

    public HasCanvasListeners<CanvasShapeListener> clearRegistrationListeners() {
        this.listeners.clear();
        return this;
    }

    protected void fireCanvasShapeAdded(Shape shape) {
        for (CanvasShapeListener instance : this.listeners) {
            instance.register((Object)shape);
        }
    }

    protected void fireCanvasShapeRemoved(Shape shape) {
        for (CanvasShapeListener instance : this.listeners) {
            instance.deregister((Object)shape);
        }
    }

    protected void fireCanvasClear() {
        for (CanvasShapeListener instance : this.listeners) {
            instance.clear();
        }
    }

    protected void afterDrawCanvas() {
    }

    public int getWidth() {
        return this.getView().getWidth();
    }

    public int getHeight() {
        return this.getView().getHeight();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCanvas)) {
            return false;
        }
        AbstractCanvas that = (AbstractCanvas)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }

    public static interface CanvasView<C extends CanvasView>
    extends IsWidget {
        public C initialize(CanvasPanel var1, CanvasSettings var2);

        public C add(ShapeView<?> var1);

        public C delete(ShapeView<?> var1);

        public C addChild(ShapeView<?> var1, ShapeView<?> var2);

        public C deleteChild(ShapeView<?> var1, ShapeView<?> var2);

        public C dock(ShapeView<?> var1, ShapeView<?> var2);

        public C undock(ShapeView<?> var1, ShapeView<?> var2);

        public C setGrid(CanvasGrid var1);

        public C setCursor(Cursors var1);

        public C clear();

        public Transform getTransform();

        public Point2D getAbsoluteLocation();

        public int getWidth();

        public int getHeight();

        public void destroy();
    }

    public static enum Cursors {
        AUTO,
        MOVE,
        POINTER,
        TEXT,
        NOT_ALLOWED,
        WAIT,
        CROSSHAIR;

    }
}

