/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.Optional;
import java.util.function.Consumer;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.CloneCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class CloneNodeCommand
extends AbstractCanvasGraphCommand {
    private final Node candidate;
    private final String parentUuid;
    private Optional<Point2D> cloneLocation;
    private transient CompositeCommand<AbstractCanvasHandler, CanvasViolation> command;
    private final Optional<Consumer<Node>> cloneNodeCommandCallback;
    private final ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessor;

    public CloneNodeCommand(Node candidate, String parentUuid, Point2D cloneLocation, Consumer<Node> cloneNodeCommandCallback, ManagedInstance<ChildrenTraverseProcessor> childrenTraverseProcessor) {
        this.candidate = candidate;
        this.cloneLocation = Optional.ofNullable(cloneLocation);
        this.parentUuid = parentUuid;
        this.cloneNodeCommandCallback = Optional.ofNullable(cloneNodeCommandCallback);
        this.childrenTraverseProcessor = childrenTraverseProcessor;
        this.command = this.buildCommand();
    }

    private CompositeCommand<AbstractCanvasHandler, CanvasViolation> buildCommand() {
        return new CompositeCommand.Builder().reverse().build();
    }

    @Override
    protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new org.kie.workbench.common.stunner.core.graph.command.impl.CloneNodeCommand(this.candidate, this.parentUuid, this.getClonePosition(), this.cloneNodeCallback(context), this.childrenTraverseProcessor);
    }

    @Override
    protected Command<AbstractCanvasHandler, CanvasViolation> newCanvasCommand(AbstractCanvasHandler context) {
        return this.command;
    }

    protected Point2D getClonePosition() {
        return this.cloneLocation.orElseGet(() -> GraphUtils.getPosition((View)((View)this.candidate.getContent())));
    }

    protected Consumer<Node> cloneNodeCallback(AbstractCanvasHandler context) {
        return clone -> {
            if (!this.command.isEmpty()) {
                this.command = this.buildCommand();
            }
            this.command.addCommand((Command)this.getCloneCanvasNodeCommand(GraphUtils.getParent((Node)clone).asNode(), (Node)clone, context.getDiagram().getMetadata().getShapeSetId()));
            this.cloneNodeCommandCallback.ifPresent(callback -> callback.accept(clone));
        };
    }

    public CloneCanvasNodeCommand getCloneCanvasNodeCommand(Node parent, Node clone, String shapeId) {
        return new CloneCanvasNodeCommand(parent, clone, shapeId, this.childrenTraverseProcessor);
    }

    public ManagedInstance<ChildrenTraverseProcessor> getChildrenTraverseProcessor() {
        return this.childrenTraverseProcessor;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    protected String getParentUuid() {
        return this.parentUuid;
    }
}

