/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

public class UpdateCanvasElementPositionCommand
extends AbstractCanvasCommand {
    private final Element<?> element;

    public UpdateCanvasElementPositionCommand(Element<?> element) {
        this.element = element;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        context.updateElementPosition(this.element, MutationContext.STATIC);
        this.moveConnectorsToTop(context);
        return this.buildResult();
    }

    private void moveConnectorsToTop(AbstractCanvasHandler context) {
        if (this.getElement() instanceof Node) {
            ShapeUtils.moveViewConnectorsToTop(context, (Node)this.getElement());
        }
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return this.execute(context);
    }

    public Element<?> getElement() {
        return this.element;
    }

    public String toString() {
        return this.getClass().getName() + " [element=" + this.getUUID(this.element) + "]";
    }
}

