/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractCanvasHandlerRegistrationControl<H extends AbstractCanvasHandler>
extends AbstractCanvasHandlerControl<H>
implements CanvasRegistrationControl<H, Element> {
    private static Logger LOGGER = Logger.getLogger(AbstractCanvasHandlerRegistrationControl.class.getName());
    private final Map<String, Set<ViewHandler<?>>> handlers = new HashMap();
    private final Map<String, Set<ViewHandler<?>>> disabledHandlers = new HashMap();

    public void update(Element element) {
    }

    protected void registerHandler(String uuid, ViewHandler<?> handler) {
        this.handlers.putIfAbsent(uuid, new HashSet());
        this.handlers.get(uuid).add(handler);
    }

    @Override
    protected void doInit() {
        this.enableAllHandlers();
    }

    public void clear() {
        this.doClear();
    }

    private void enableAllHandlers() {
        if (!this.handlers.isEmpty() && Objects.nonNull(this.canvasHandler)) {
            this.handlers.keySet().stream().filter(this::isRegistered).map(uuid -> this.canvasHandler.getCanvas().getShape(uuid)).filter(Objects::nonNull).filter(shape -> shape.getShapeView() instanceof HasEventHandlers).forEach(shape -> this.disabledHandlers.get(shape.getUUID()).stream().forEach(eventHandler -> {
                ((HasEventHandlers)shape.getShapeView()).addHandler(eventHandler.getType(), eventHandler);
                this.handlers.get(shape.getUUID()).add((ViewHandler<?>)eventHandler);
            }));
            this.disabledHandlers.values().stream().forEach(Set::clear);
            this.disabledHandlers.clear();
        }
    }

    protected void doClear() {
        new HashSet<String>(this.handlers.keySet()).stream().forEach(this::deregister);
        this.handlers.clear();
        new HashSet<String>(this.disabledHandlers.keySet()).stream().forEach(this::deregister);
        this.disabledHandlers.clear();
    }

    @Override
    protected void doDestroy() {
        this.doClear();
    }

    public void deregister(Element element) {
        this.deregister(element.getUUID());
    }

    public boolean isRegistered(Element element) {
        return this.isRegistered(element.getUUID());
    }

    protected Set<String> getRegisteredElements() {
        return this.handlers.entrySet().stream().filter(entry -> Objects.nonNull(entry.getValue())).filter(entry -> !((Set)entry.getValue()).isEmpty()).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    protected boolean isRegistered(String uuid) {
        return this.handlers.containsKey(uuid);
    }

    protected void deregister(String uuid) {
        if (this.isRegistered(uuid)) {
            Shape shape = this.canvasHandler.getCanvas().getShape(uuid);
            this.handlers.get(uuid).stream().forEach(handler -> this.doDeregisterHandler(shape, (ViewHandler<?>)handler));
            this.handlers.get(uuid).clear();
            this.handlers.remove(uuid);
        }
    }

    protected boolean checkNotRegistered(Element element) {
        if (this.isRegistered(element)) {
            LOGGER.log(Level.WARNING, "Trying to register element [" + element.getUUID() + "] again into the control for type [" + this.getClass().getName() + "]");
            return false;
        }
        return true;
    }

    protected boolean checkEventContext(AbstractCanvasHandlerEvent canvasHandlerEvent) {
        CanvasHandler _canvasHandler = canvasHandlerEvent.getCanvasHandler();
        return this.canvasHandler != null && this.canvasHandler.equals(_canvasHandler);
    }

    private void doDeregisterHandler(Shape shape, ViewHandler<?> handler) {
        if (null != shape && null != handler) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            hasEventHandlers.removeHandler(handler);
            this.disabledHandlers.putIfAbsent(shape.getUUID(), new HashSet());
            this.disabledHandlers.get(shape.getUUID()).add(handler);
        }
    }
}

