/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.layout;

import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.HasBounds;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;
import org.kie.workbench.common.stunner.core.graph.processing.layout.Layout;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutExecutor;
import org.kie.workbench.common.stunner.core.graph.processing.layout.LayoutService;

public final class LayoutHelper {
    private final LayoutService layoutService;
    private final LayoutExecutor layoutExecutor;

    @Inject
    public LayoutHelper(LayoutService layoutService, LayoutExecutor layoutExecutor) {
        this.layoutService = layoutService;
        this.layoutExecutor = layoutExecutor;
    }

    public void applyLayout(Diagram diagram) {
        Graph graph = diagram.getGraph();
        if (graph != null && !this.layoutService.hasLayoutInformation(graph)) {
            Layout layout = this.layoutService.createLayout(graph);
            this.layoutExecutor.applyLayout(layout, graph);
            for (Node node : graph.nodes()) {
                if (!CanvasLayoutUtils.isCanvasRoot(diagram, (Element)node) || !(node.getContent() instanceof HasBounds)) continue;
                ((HasBounds)node.getContent()).setBounds((Bounds)BoundsImpl.build((double)0.0, (double)0.0, (double)0.0, (double)0.0));
            }
        }
    }
}

