/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateConnectorAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CreateNodeAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.FlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxDomainLookups;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.lookup.domain.CommonDomainLookups;
import org.uberfire.mvp.Command;

@Dependent
@FlowActionsToolbox
public class FlowActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final ToolboxDomainLookups toolboxDomainLookups;
    private final Supplier<CreateConnectorAction> createConnectorActions;
    private final Command createConnectorActionsDestroyer;
    private final Supplier<CreateNodeAction> createNodeActions;
    private final Command createNodeActionsDestroyer;
    private final Supplier<ActionsToolboxView> views;
    private final Command viewsDestroyer;

    @Inject
    public FlowActionsToolboxFactory(ToolboxDomainLookups toolboxDomainLookups, @Any ManagedInstance<CreateConnectorAction> createConnectorActions, @Any @FlowActionsToolbox ManagedInstance<CreateNodeAction> createNodeActions, @Any @FlowActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this(toolboxDomainLookups, () -> createConnectorActions.get(), () -> createConnectorActions.destroyAll(), () -> createNodeActions.get(), () -> createNodeActions.destroyAll(), () -> views.get(), () -> views.destroyAll());
    }

    FlowActionsToolboxFactory(ToolboxDomainLookups toolboxDomainLookups, Supplier<CreateConnectorAction> createConnectorActions, Command createConnectorActionsDestroyer, Supplier<CreateNodeAction> createNodeActions, Command createNodeActionsDestroyer, Supplier<ActionsToolboxView> views, Command viewsDestroyer) {
        this.toolboxDomainLookups = toolboxDomainLookups;
        this.createConnectorActions = createConnectorActions;
        this.createConnectorActionsDestroyer = createConnectorActionsDestroyer;
        this.createNodeActions = createNodeActions;
        this.createNodeActionsDestroyer = createNodeActionsDestroyer;
        this.views = views;
        this.viewsDestroyer = viewsDestroyer;
    }

    @Override
    protected ActionsToolboxView<?> newViewInstance() {
        return this.views.get();
    }

    @Override
    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> element) {
        String defaultConnectorId;
        Diagram diagram = canvasHandler.getDiagram();
        String defSetId = diagram.getMetadata().getDefinitionSetId();
        LinkedHashSet<ToolboxAction<AbstractCanvasHandler>> actions = new LinkedHashSet<ToolboxAction<AbstractCanvasHandler>>();
        Node node = (Node)element;
        CommonDomainLookups lookup = this.toolboxDomainLookups.get(defSetId);
        Set targetConnectors = lookup.lookupTargetConnectors(node);
        targetConnectors.forEach(connectorDefId -> actions.add(this.createConnectorActions.get().setEdgeId((String)connectorDefId)));
        String string = defaultConnectorId = !targetConnectors.isEmpty() ? (String)targetConnectors.iterator().next() : null;
        if (null != defaultConnectorId) {
            Set targets = lookup.lookupTargetNodes(diagram.getGraph(), node, defaultConnectorId);
            Set morphTargets = lookup.lookupMorphBaseDefinitions(targets);
            morphTargets.forEach(defId -> actions.add(this.createNodeActions.get().setEdgeId(defaultConnectorId).setNodeId((String)defId)));
        }
        return actions;
    }

    @PreDestroy
    public void destroy() {
        this.createConnectorActionsDestroyer.execute();
        this.createNodeActionsDestroyer.execute();
        this.viewsDestroyer.execute();
    }
}

