/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;

public class ShapeStateAttributeHandler<V extends ShapeView>
implements ShapeStateHandler {
    private final BiConsumer<V, ShapeStateAttributes> stateAttributesApplier;
    private final ShapeStateAttributes stateHolder;
    private Function<ShapeState, ShapeStateAttributes> stateAttributesProvider;
    private ShapeState state;
    private Supplier<V> view;

    public static <V extends ShapeView> BiConsumer<V, ShapeStateAttributes> newDefaultStateApplier() {
        return (view1, attributes) -> attributes.consume((attr, value) -> ((ShapeStateAttribute)attr).valueApplier.accept(view1, value));
    }

    public ShapeStateAttributeHandler() {
        this(ShapeStateAttributeHandler.newDefaultStateApplier());
    }

    public ShapeStateAttributeHandler(BiConsumer<V, ShapeStateAttributes> stateAttributesApplier) {
        this.stateAttributesApplier = stateAttributesApplier;
        this.stateHolder = new ShapeStateAttributes();
        this.state = ShapeState.NONE;
    }

    public ShapeStateAttributeHandler<V> useAttributes(Function<ShapeState, ShapeStateAttributes> stateAttributesProvider) {
        this.stateAttributesProvider = stateAttributesProvider;
        return this;
    }

    public ShapeStateAttributeHandler<V> setView(Supplier<V> viewSupplier) {
        this.setViewSupplier(viewSupplier);
        this.state = ShapeState.NONE;
        this.saveState();
        return this;
    }

    @Override
    public ShapeStateAttributeHandler<V> shapeAttributesChanged() {
        if (this.state.equals((Object)ShapeState.NONE)) {
            this.saveState();
        }
        return this;
    }

    private void saveState() {
        this.stateHolder.store((ShapeView)this.view.get());
    }

    public void applyState(ShapeState shapeState) {
        if (!this.state.equals((Object)shapeState)) {
            this.state = shapeState;
            ShapeStateAttributes stateHolder = this.stateHolder.copy();
            this.stateAttributesProvider.apply(shapeState).consume(stateHolder.values::put);
            this.stateAttributesApplier.accept(this.getShapeView(), stateHolder);
        }
    }

    @Override
    public ShapeState reset() {
        ShapeState result = this.state;
        ShapeStateAttributeHandler.newDefaultStateApplier().accept(this.getShapeView(), this.stateHolder.copy());
        this.state = ShapeState.NONE;
        return result;
    }

    @Override
    public ShapeState getShapeState() {
        return this.state;
    }

    public V getShapeView() {
        return (V)(Objects.nonNull(this.view) ? (ShapeView)this.view.get() : null);
    }

    void setViewSupplier(Supplier<V> view) {
        this.view = view;
    }

    ShapeStateAttributes getStateHolder() {
        return this.stateHolder;
    }

    public static class ShapeStateAttributes {
        private final Map<ShapeStateAttribute, Object> values;

        ShapeStateAttributes() {
            this(new HashMap<ShapeStateAttribute, Object>(ShapeStateAttribute.values().length));
            for (ShapeStateAttribute attribute : ShapeStateAttribute.values()) {
                this.add(attribute);
            }
        }

        private ShapeStateAttributes(Map<ShapeStateAttribute, Object> values) {
            this.values = values;
        }

        private ShapeStateAttributes add(ShapeStateAttribute attribute) {
            this.values.put(attribute, null);
            return this;
        }

        public ShapeStateAttributes set(ShapeStateAttribute attribute, Object value) {
            this.values.put(attribute, value);
            return this;
        }

        public ShapeStateAttributes unset(ShapeStateAttribute attribute) {
            this.values.put(attribute, null);
            return this;
        }

        public ShapeStateAttributes copy() {
            return new ShapeStateAttributes(new HashMap<ShapeStateAttribute, Object>(this.values));
        }

        private ShapeStateAttributes store(ShapeView<?> view) {
            new HashSet<ShapeStateAttribute>(this.values.keySet()).forEach(attr -> this.values.put((ShapeStateAttribute)((Object)attr), ((ShapeStateAttribute)attr).valueProvider.apply(view)));
            return this;
        }

        public ShapeStateAttributes consume(BiConsumer<ShapeStateAttribute, Object> attribute) {
            this.values.forEach((key, value) -> {
                if (null != value) {
                    attribute.accept((ShapeStateAttribute)((Object)key), value);
                }
            });
            return this;
        }

        public Map<ShapeStateAttribute, Object> getValues() {
            return this.values;
        }
    }

    public static enum ShapeStateAttribute {
        FILL_COLOR(ShapeView::getFillColor, (view, color) -> view.setFillColor((String)color)),
        FILL_ALPHA(ShapeView::getFillAlpha, (view, value) -> view.setFillAlpha(((Double)value).doubleValue())),
        STROKE_COLOR(ShapeView::getStrokeColor, (view, color) -> view.setStrokeColor((String)color)),
        STROKE_ALPHA(ShapeView::getStrokeAlpha, (view, value) -> view.setStrokeAlpha(((Double)value).doubleValue())),
        STROKE_WIDTH(ShapeView::getStrokeWidth, (view, value) -> view.setStrokeWidth(((Double)value).doubleValue()));

        private final Function<ShapeView<?>, Object> valueProvider;
        private final BiConsumer<ShapeView<?>, Object> valueApplier;

        private ShapeStateAttribute(Function<ShapeView<?>, Object> valueProvider, BiConsumer<ShapeView<?>, Object> valueApplier) {
            this.valueProvider = valueProvider;
            this.valueApplier = valueApplier;
        }
    }
}

