/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasPanel;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasSettings;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.uberfire.client.workbench.widgets.listbar.ResizeFlowPanel;

public abstract class AbstractCanvasView<V extends AbstractCanvasView>
extends Composite
implements AbstractCanvas.CanvasView<V>,
ProvidesResize,
RequiresResize {
    public static final String CURSOR = "cursor";
    public static final String CURSOR_NOT_ALLOWED = "not-allowed";
    private final ResizeFlowPanel mainPanel = new ResizeFlowPanel();
    private CanvasPanel canvasPanel;

    protected abstract V doInitialize(CanvasSettings var1);

    protected abstract void doDestroy();

    @PostConstruct
    public void init() {
        this.initWidget((Widget)this.mainPanel);
        this.mainPanel.getElement().getStyle().setWidth(100.0, Style.Unit.PCT);
        this.mainPanel.getElement().getStyle().setHeight(100.0, Style.Unit.PCT);
    }

    @Override
    public final V initialize(CanvasPanel canvasPanel, CanvasSettings canvasSettings) {
        this.canvasPanel = canvasPanel;
        this.doInitialize(canvasSettings);
        this.mainPanel.add((IsWidget)canvasPanel);
        return this.cast();
    }

    public void onResize() {
        this.mainPanel.onResize();
    }

    @Override
    public V setCursor(AbstractCanvas.Cursors cursor) {
        Style style = this.canvasPanel.asWidget().getElement().getStyle();
        switch (cursor) {
            case AUTO: {
                style.setCursor(Style.Cursor.AUTO);
                break;
            }
            case MOVE: {
                style.setCursor(Style.Cursor.MOVE);
                break;
            }
            case TEXT: {
                style.setCursor(Style.Cursor.TEXT);
                break;
            }
            case POINTER: {
                style.setCursor(Style.Cursor.POINTER);
                break;
            }
            case NOT_ALLOWED: {
                style.setProperty(CURSOR, CURSOR_NOT_ALLOWED);
                break;
            }
            case WAIT: {
                style.setCursor(Style.Cursor.WAIT);
                break;
            }
            case CROSSHAIR: {
                style.setCursor(Style.Cursor.CROSSHAIR);
            }
        }
        return this.cast();
    }

    @Override
    public Point2D getAbsoluteLocation() {
        return new Point2D((double)this.getAbsoluteLeft(), (double)this.getAbsoluteTop());
    }

    @Override
    public CanvasPanel getPanel() {
        return this.canvasPanel;
    }

    @Override
    public final void destroy() {
        this.doDestroy();
        this.canvasPanel.destroy();
        this.mainPanel.clear();
        this.canvasPanel = null;
    }

    private V cast() {
        return (V)this;
    }
}

