/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import java.util.Optional;

public class CanvasSettings {
    private final Optional<CanvasSize> canvasSize;
    private final boolean isHiDPIEnabled;

    public CanvasSettings(boolean isHiDPIEnabled) {
        this.canvasSize = Optional.empty();
        this.isHiDPIEnabled = isHiDPIEnabled;
    }

    public CanvasSettings(int width, int height, boolean isHiDPIEnabled) {
        this.canvasSize = Optional.of(new CanvasSize(width, height));
        this.isHiDPIEnabled = isHiDPIEnabled;
    }

    public Optional<CanvasSize> getCanvasSize() {
        return this.canvasSize;
    }

    public boolean isHiDPIEnabled() {
        return this.isHiDPIEnabled;
    }

    public static class CanvasSize {
        private final int width;
        private final int height;

        public CanvasSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

