/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import java.util.Objects;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasControlPointCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolationImpl;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.RuleViolationImpl;

public class AddCanvasControlPointCommand
extends AbstractCanvasCommand {
    private final Edge candidate;
    private final ControlPoint[] controlPoints;
    private Boolean allowed;

    public AddCanvasControlPointCommand(Edge candidate, ControlPoint ... controlPoints) {
        this.candidate = candidate;
        this.controlPoints = controlPoints;
    }

    @Override
    public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context) {
        ShapeUtils.hideControlPoints(this.candidate, context);
        List<ControlPoint> addedControlPoints = ShapeUtils.addControlPoints(this.candidate, context, this.controlPoints);
        if (addedControlPoints.stream().map(ControlPoint::getIndex).anyMatch(Objects::isNull)) {
            new CanvasViolationImpl.Builder();
            return new CanvasCommandResultBuilder().setType(CommandResult.Type.ERROR).addViolation((Object)CanvasViolationImpl.Builder.build((RuleViolation)new RuleViolationImpl("Control Point out of connector"))).build();
        }
        ShapeUtils.showControlPoints(this.candidate, context);
        this.allowed = Boolean.TRUE;
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        CommandResult<CanvasViolation> commandResult;
        if (Objects.isNull(this.allowed) && CommandUtils.isError(commandResult = this.allow(context))) {
            return commandResult;
        }
        this.allowed = null;
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new DeleteCanvasControlPointCommand(this.candidate, this.controlPoints).execute(context);
    }

    public ControlPoint[] getControlPoints() {
        return this.controlPoints;
    }
}

