/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

public class DeleteCanvasConnectorCommand
extends AbstractCanvasCommand {
    private final Edge candidate;

    public DeleteCanvasConnectorCommand(Edge candidate) {
        this.candidate = candidate;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        Node target;
        if (!this.checkShapeNotNull(context, this.candidate.getUUID())) {
            return this.buildResult();
        }
        context.deregister((Element)this.candidate);
        Node source = this.candidate.getSourceNode();
        if (null != source) {
            context.notifyCanvasElementUpdated((Element)source);
        }
        if (null != (target = this.candidate.getTargetNode())) {
            context.notifyCanvasElementUpdated((Element)target);
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        String ssid = context.getDiagram().getMetadata().getShapeSetId();
        return new AddCanvasConnectorCommand(this.candidate, ssid).execute(context);
    }

    public Edge getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return this.getClass().getName() + " [candidate=" + this.getUUID((Element<?>)this.candidate) + ", sourceNode=" + this.getUUID((Element<?>)this.candidate.getSourceNode()) + ", targetNode=" + this.getUUID((Element<?>)this.candidate.getTargetNode()) + "]";
    }
}

