/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddCanvasChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;

public class DeleteCanvasNodeCommand
extends AbstractCanvasCommand {
    private final Node candidate;
    private final Node parent;

    public DeleteCanvasNodeCommand(Node candidate) {
        this.candidate = candidate;
        this.parent = DeleteCanvasNodeCommand.getParent(candidate);
    }

    public DeleteCanvasNodeCommand(Node candidate, Node parent) {
        this.candidate = candidate;
        this.parent = parent;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        if (null != this.parent) {
            context.removeChild((Element)this.parent, (Element)this.candidate);
        }
        context.deregister((Element)this.candidate);
        if (null != this.parent) {
            context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        String ssid = context.getDiagram().getMetadata().getShapeSetId();
        AbstractCanvasCommand command = this.createUndoCommand(this.parent, this.candidate, ssid);
        return command.execute(context);
    }

    public static Node getParent(Node node) {
        List inEdges;
        List list = inEdges = null != node ? node.getInEdges() : null;
        if (null != inEdges && !inEdges.isEmpty()) {
            for (Edge edge : inEdges) {
                if (!DeleteCanvasNodeCommand.isChildEdge(edge) && !DeleteCanvasNodeCommand.isDockEdge(edge)) continue;
                return edge.getSourceNode();
            }
        }
        return null;
    }

    public static boolean isChildEdge(Edge edge) {
        return edge.getContent() instanceof Child;
    }

    public static boolean isDockEdge(Edge edge) {
        return edge.getContent() instanceof Dock;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    protected AbstractCanvasCommand createUndoCommand(Node parent, Node candidate, String ssid) {
        return new AddCanvasChildNodeCommand(parent, candidate, ssid);
    }

    public String toString() {
        return this.getClass().getName() + " [parent=" + this.getUUID((Element<?>)this.parent) + ", candidate=" + this.getUUID((Element<?>)this.candidate) + "]";
    }
}

