/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.impl.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class UpdateCanvasElementPositionCommand
extends AbstractCanvasCommand {
    private final Element<? extends View<?>> element;
    private final Point2D location;

    public UpdateCanvasElementPositionCommand(Element<? extends View<?>> element, Point2D location) {
        this.element = element;
        this.location = location;
    }

    @Override
    public CommandResult<CanvasViolation> allow(AbstractCanvasHandler context) {
        Bounds targetBounds = UpdateElementPositionCommand.computeCandidateBounds(this.element, (Point2D)this.location);
        if (CanvasUtils.areBoundsExceeded(context, targetBounds)) {
            return CanvasUtils.createBoundsExceededCommandResult(context, targetBounds);
        }
        return super.allow(context);
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        CommandResult<CanvasViolation> allowResult = this.allow(context);
        if (CommandUtils.isError(allowResult)) {
            return allowResult;
        }
        context.updateElementPosition(this.element, MutationContext.STATIC);
        this.moveConnectorsToTop(context);
        return this.buildResult();
    }

    private void moveConnectorsToTop(AbstractCanvasHandler context) {
        if (this.getElement() instanceof Node) {
            ShapeUtils.moveViewConnectorsToTop(context, (Node)this.getElement());
        }
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return this.execute(context);
    }

    public Element<? extends View<?>> getElement() {
        return this.element;
    }

    public Point2D getLocation() {
        return this.location;
    }

    public String toString() {
        return this.getClass().getName() + " [element=" + this.getUUID(this.element) + "]";
    }
}

