/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl;

import com.google.gwt.user.client.Element;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.AbstractElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.impl.Observer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.ElementBuildRequestImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.event.BuildCanvasShapeEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasSelectionEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationMessages;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.processing.index.bounds.GraphBoundsIndexer;
import org.kie.workbench.common.stunner.core.rule.RuleManager;

@Default
@Observer
@Dependent
public class ObserverBuilderControl
extends AbstractElementBuilderControl
implements ElementBuilderControl<AbstractCanvasHandler> {
    private static Logger LOGGER = Logger.getLogger(ObserverBuilderControl.class.getName());
    private final Event<CanvasSelectionEvent> canvasSelectionEvent;

    @Inject
    public ObserverBuilderControl(ClientDefinitionManager clientDefinitionManager, ClientFactoryService clientFactoryServices, RuleManager ruleManager, CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory, ClientTranslationMessages translationMessages, GraphBoundsIndexer graphBoundsIndexer, Event<CanvasSelectionEvent> canvasSelectionEvent) {
        super(clientDefinitionManager, clientFactoryServices, ruleManager, canvasCommandFactory, translationMessages, graphBoundsIndexer);
        this.canvasSelectionEvent = canvasSelectionEvent;
    }

    public void buildShapeAt(Object definition, double x, double y) {
        ElementBuildRequestImpl request = new ElementBuildRequestImpl(x, y, definition);
        this.build(request, new BuilderControl.BuildCallback(){

            public void onSuccess(String uuid) {
                ObserverBuilderControl.this.canvasSelectionEvent.fire((Object)new CanvasSelectionEvent((CanvasHandler)ObserverBuilderControl.this.canvasHandler, uuid));
            }

            public void onError(ClientRuntimeError error) {
                LOGGER.log(Level.WARNING, error.toString());
            }
        });
    }

    void onBuildCanvasShape(@Observes BuildCanvasShapeEvent event) {
        Object context;
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (null != this.canvasHandler && null != (context = event.getCanvasHandler()) && context.equals(this.canvasHandler)) {
            Point2D transformed = this.getTransformedLocation(event.getClientX(), event.getClientY());
            this.buildShapeAt(event.getDefinition(), transformed.getX(), transformed.getY());
        }
    }

    public Point2D getTransformedLocation(double clientX, double clientY) {
        double x = this.getRelativeX(clientX);
        double y = this.getRelativeY(clientY);
        return this.canvasHandler.getAbstractCanvas().getTransform().inverse(x, y);
    }

    private double getRelativeX(double clientX) {
        return clientX - (double)this.getCanvasElement().getAbsoluteLeft() + (double)this.getCanvasElement().getScrollLeft() + (double)this.getCanvasElement().getOwnerDocument().getScrollLeft();
    }

    private double getRelativeY(double clientY) {
        return clientY - (double)this.getCanvasElement().getAbsoluteTop() + (double)this.getCanvasElement().getScrollTop() + (double)this.getCanvasElement().getOwnerDocument().getScrollTop();
    }

    private Element getCanvasElement() {
        return this.canvasHandler.getAbstractCanvas().getView().asWidget().getElement();
    }
}

