/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.components.toolbox.Toolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxFactory;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;

public class ToolboxControlImpl<F extends ToolboxFactory<AbstractCanvasHandler, Element>>
extends AbstractCanvasHandlerRegistrationControl<AbstractCanvasHandler>
implements ToolboxControl<AbstractCanvasHandler, Element> {
    private final Supplier<List<F>> toolboxFactories;
    private final Toolboxes toolboxes = new Toolboxes();
    private final Predicate<String> showToolboxPredicate;
    public static final Predicate<String> ALWAYS_SHOW_PREDICATE = id -> true;

    ToolboxControlImpl(Supplier<List<F>> toolboxFactories) {
        this(toolboxFactories, ALWAYS_SHOW_PREDICATE);
    }

    ToolboxControlImpl(Supplier<List<F>> toolboxFactories, Predicate<String> showToolboxPredicate) {
        this.toolboxFactories = toolboxFactories;
        this.showToolboxPredicate = showToolboxPredicate;
    }

    public void register(final Element element) {
        Shape shape;
        HasEventHandlers hasEventHandlers;
        if (this.checkNotRegistered(element) && this.supportsToolbox(element) && (hasEventHandlers = (HasEventHandlers)(shape = this.canvasHandler.getCanvas().getShape(element.getUUID())).getShapeView()).supports(ViewEventType.MOUSE_CLICK)) {
            MouseClickHandler clickHandler = new MouseClickHandler(){

                public void handle(MouseClickEvent event) {
                    if (event.isButtonLeft()) {
                        ToolboxControlImpl.this.show(element);
                    }
                }
            };
            hasEventHandlers.addHandler(ViewEventType.MOUSE_CLICK, (ViewHandler)clickHandler);
            this.registerHandler(element.getUUID(), (ViewHandler<?>)clickHandler);
        }
    }

    public Iterator<Toolbox<?>> getToolboxes(Element element) {
        this.load(element);
        return this.toolboxes.list.iterator();
    }

    @Override
    protected void doDestroy() {
        this.hideAndDestroyToolboxes();
        super.doDestroy();
    }

    public void destroyToolboxes() {
        this.toolboxes.destroy();
    }

    public void hideAndDestroyToolboxes() {
        this.toolboxes.hideAndDestroy();
    }

    public ToolboxControl<AbstractCanvasHandler, Element> show(String uuid) {
        Node node;
        if (this.showToolboxPredicate.test(uuid) && null != (node = this.canvasHandler.getGraphIndex().getNode(uuid))) {
            return this.show((Element)node);
        }
        return this;
    }

    public ToolboxControl<AbstractCanvasHandler, Element> show(Element element) {
        if (this.showToolboxPredicate.test(element.getUUID())) {
            if (!this.toolboxes.isTheElement(element)) {
                this.load(element);
            }
            this.toolboxes.show();
        }
        return this;
    }

    public AbstractCanvasHandler getCanvasHandler() {
        return this.canvasHandler;
    }

    public boolean isActive(String uuid) {
        return null != this.toolboxes.uuid && this.toolboxes.uuid.equals(uuid);
    }

    private void load(Element element) {
        if (this.isRegistered(element)) {
            this.load((Node)element);
        } else {
            this.destroyToolboxes();
        }
    }

    private void load(Node<?, Edge> node) {
        this.toolboxes.load(node);
    }

    private boolean supportsToolbox(Element element) {
        return element instanceof Node;
    }

    private class Toolboxes {
        private String uuid = null;
        private List<Toolbox<?>> list = Collections.emptyList();

        public Toolboxes load(Node<?, Edge> element) {
            this.destroy();
            if (!this.isCanvasRoot((Element<?>)element)) {
                this.uuid = element.getUUID();
                this.list = ((List)ToolboxControlImpl.this.toolboxFactories.get()).stream().map(factory -> factory.build((CanvasHandler)ToolboxControlImpl.this.canvasHandler, (Element)element)).flatMap(factory -> factory.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toList());
            }
            return this;
        }

        public void show() {
            this.list.forEach(Toolbox::show);
        }

        public void hide() {
            this.list.forEach(Toolbox::hide);
        }

        public void hideAndDestroy() {
            this.list.forEach(Toolbox::hideAndDestroy);
            this.clear();
        }

        public void destroy() {
            this.list.forEach(Toolbox::destroy);
            this.clear();
        }

        private void clear() {
            this.list.clear();
            this.uuid = null;
        }

        public boolean isTheElement(String _uuid) {
            return null != this.uuid && this.uuid.equals(_uuid);
        }

        public boolean isTheElement(Element<?> e) {
            return this.isTheElement(e.getUUID());
        }

        private boolean isCanvasRoot(Element<?> element) {
            return element.getUUID().equals(ToolboxControlImpl.this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID());
        }
    }
}

