/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.MorphActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.MorphNodeAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.definition.adapter.MorphAdapter;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.profile.DomainProfileManager;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.uberfire.mvp.Command;

@Dependent
@MorphActionsToolbox
public class MorphActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final DefinitionUtils definitionUtils;
    private final DomainProfileManager profileManager;
    private final Supplier<MorphNodeAction> morphNodeActions;
    private final Command morphNodeActionsDestroyer;
    private final Supplier<ActionsToolboxView> views;
    private final Command viewsDestroyer;

    @Inject
    public MorphActionsToolboxFactory(DefinitionUtils definitionUtils, DomainProfileManager profileManager, @Any ManagedInstance<MorphNodeAction> morphNodeActions, @Any @MorphActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this(definitionUtils, profileManager, () -> morphNodeActions.get(), () -> morphNodeActions.destroyAll(), () -> views.get(), () -> views.destroyAll());
    }

    MorphActionsToolboxFactory(DefinitionUtils definitionUtils, DomainProfileManager profileManager, Supplier<MorphNodeAction> morphNodeActions, Command morphNodeActionsDestroyer, Supplier<ActionsToolboxView> views, Command viewsDestroyer) {
        this.definitionUtils = definitionUtils;
        this.profileManager = profileManager;
        this.morphNodeActions = morphNodeActions;
        this.morphNodeActionsDestroyer = morphNodeActionsDestroyer;
        this.views = views;
        this.viewsDestroyer = viewsDestroyer;
    }

    private DefinitionManager getDefinitionManager() {
        return this.definitionUtils.getDefinitionManager();
    }

    @Override
    protected ActionsToolboxView<?> newViewInstance() {
        return this.views.get();
    }

    @Override
    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> e) {
        Element<?> element;
        Object definition;
        LinkedHashSet<ToolboxAction<AbstractCanvasHandler>> actions = new LinkedHashSet<ToolboxAction<AbstractCanvasHandler>>();
        if (null != e.asNode() && this.definitionUtils.hasMorphTargets(definition = ((Definition)(element = e).getContent()).getDefinition())) {
            String id = this.getDefinitionManager().adapters().forDefinition().getId(definition).value();
            MorphAdapter morphAdapter = this.getDefinitionManager().adapters().registry().getMorphAdapter(definition.getClass());
            Iterable morphDefinitions = morphAdapter.getMorphDefinitions(definition);
            if (null != morphDefinitions && morphDefinitions.iterator().hasNext()) {
                Metadata metadata = canvasHandler.getDiagram().getMetadata();
                Predicate definitionsAllowedFilter = this.profileManager.isDefinitionIdAllowed(metadata);
                LinkedHashMap<String, MorphDefinition> definitionMap = new LinkedHashMap<String, MorphDefinition>();
                for (MorphDefinition morphDefinition2 : morphDefinitions) {
                    Iterable morphTargets = morphAdapter.getTargets(definition, morphDefinition2);
                    if (null == morphTargets || !morphTargets.iterator().hasNext()) continue;
                    for (String morphTarget : morphTargets) {
                        if (id.equals(morphTarget) || !definitionsAllowedFilter.test(morphTarget)) continue;
                        definitionMap.put(morphTarget, morphDefinition2);
                    }
                }
                definitionMap.forEach((targetMorphId, morphDefinition) -> actions.add(this.morphNodeActions.get().setMorphDefinition((MorphDefinition)morphDefinition).setTargetDefinitionId((String)targetMorphId)));
            }
        }
        return actions;
    }

    @PreDestroy
    public void destroy() {
        this.morphNodeActionsDestroyer.execute();
        this.viewsDestroyer.execute();
    }
}

