/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.impl;

import java.util.List;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.AbstractElementShape;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeImpl;
import org.kie.workbench.common.stunner.core.client.shape.impl.ShapeStateHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.HasManageableControlPoints;
import org.kie.workbench.common.stunner.core.client.shape.view.IsConnector;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeViewDef;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;

public class ConnectorShape<W, D extends ShapeViewDef<W, V>, V extends ShapeView>
extends AbstractElementShape<W, ViewConnector<W>, Edge<ViewConnector<W>, Node>, D, V>
implements EdgeShape<W, ViewConnector<W>, Edge<ViewConnector<W>, Node>, V>,
Lifecycle {
    private final ShapeImpl<V> shape;

    public ConnectorShape(D shapeDef, V view, ShapeStateHandler shapeStateHelper) {
        super(shapeDef);
        this.shape = new ShapeImpl<V>(view, shapeStateHelper);
    }

    @Override
    protected ShapeImpl<V> getShape() {
        return this.shape;
    }

    public void applyConnections(Edge<ViewConnector<W>, Node> element, ShapeView<?> source, ShapeView<?> target, MutationContext mutationContext) {
        ViewConnector connectionContent = (ViewConnector)element.getContent();
        Connection sourceConnection = connectionContent.getSourceConnection().orElse(null);
        Connection targetConnection = connectionContent.getTargetConnection().orElse(null);
        IsConnector shapeView = (IsConnector)this.getShapeView();
        shapeView.connect(source, sourceConnection, target, targetConnection);
    }

    public List<ControlPoint> getControlPoints() {
        return this.getShapeViewWithControlPoints().getShapeControlPoints();
    }

    public List<ControlPoint> addControlPoints(ControlPoint ... controlPoints) {
        return this.getShapeViewWithControlPoints().addControlPoints(controlPoints);
    }

    public void removeControlPoints(ControlPoint ... controlPoints) {
        this.getShapeViewWithControlPoints().removeControlPoints(controlPoints);
    }

    public void updateControlPoint(ControlPoint controlPoint) {
        this.getShapeViewWithControlPoints().updateControlPoint(controlPoint);
    }

    private HasManageableControlPoints getShapeViewWithControlPoints() {
        if (!(this.getShapeView() instanceof HasManageableControlPoints)) {
            throw new IllegalArgumentException("ShapeView should be a HasManageableControlPoints. " + this.getShapeView());
        }
        return (HasManageableControlPoints)this.getShapeView();
    }

    public void applyPosition(Edge<ViewConnector<W>, Node> element, MutationContext mutationContext) {
    }

    public void applyState(ShapeState shapeState) {
        ((ShapeImpl)this.getShape()).applyState(shapeState);
    }
}

