/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.view.handler;

import java.util.function.Function;
import org.kie.workbench.common.stunner.core.client.shape.view.HasRadius;
import org.kie.workbench.common.stunner.core.client.shape.view.HasSize;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeViewHandler;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class SizeHandler<W, V extends ShapeView>
implements ShapeViewHandler<View<W>, V> {
    private final Function<W, Double> widthProvider;
    private final Function<W, Double> minWidthProvider;
    private final Function<W, Double> maxWidthProvider;
    private final Function<W, Double> heightProvider;
    private final Function<W, Double> minHeightProvider;
    private final Function<W, Double> maxHeightProvider;
    private final Function<W, Double> radiusProvider;
    private final Function<W, Double> minRadiusProvider;
    private final Function<W, Double> maxRadiusProvider;

    private SizeHandler(Function<W, Double> widthProvider, Function<W, Double> minWidthProvider, Function<W, Double> maxWidthProvider, Function<W, Double> heightProvider, Function<W, Double> minHeightProvider, Function<W, Double> maxHeightProvider, Function<W, Double> radiusProvider, Function<W, Double> minRadiusProvider, Function<W, Double> maxRadiusProvider) {
        this.widthProvider = widthProvider;
        this.minWidthProvider = minWidthProvider;
        this.maxWidthProvider = maxWidthProvider;
        this.heightProvider = heightProvider;
        this.minHeightProvider = minHeightProvider;
        this.maxHeightProvider = maxHeightProvider;
        this.radiusProvider = radiusProvider;
        this.minRadiusProvider = minRadiusProvider;
        this.maxRadiusProvider = maxRadiusProvider;
    }

    public void handle(View<W> content, V view) {
        Object bean = content.getDefinition();
        double boundsWidth = content.getBounds().getWidth();
        double boundsHeight = content.getBounds().getHeight();
        if (view instanceof HasSize) {
            Double beanWidth = this.widthProvider.apply(bean);
            Double beanHeight = this.heightProvider.apply(bean);
            double width = null != beanWidth ? beanWidth : boundsWidth;
            double height = null != beanHeight ? beanHeight : boundsHeight;
            Double minWidth = this.minWidthProvider.apply(bean);
            Double maxWidth = this.maxWidthProvider.apply(bean);
            Double minHeight = this.minHeightProvider.apply(bean);
            Double maxHeight = this.maxHeightProvider.apply(bean);
            HasSize hasSizeView = (HasSize)view;
            if (width > 0.0 && height > 0.0) {
                hasSizeView.setSize(width, height);
            }
            if (SizeHandler.isValidSizeConstraint(minWidth)) {
                hasSizeView.setMinWidth(minWidth);
            }
            if (SizeHandler.isValidSizeConstraint(maxWidth)) {
                hasSizeView.setMaxWidth(maxWidth);
            }
            if (SizeHandler.isValidSizeConstraint(minHeight)) {
                hasSizeView.setMinHeight(minHeight);
            }
            if (SizeHandler.isValidSizeConstraint(maxHeight)) {
                hasSizeView.setMaxHeight(maxHeight);
            }
        }
        if (view instanceof HasRadius) {
            Double beanRadius = this.radiusProvider.apply(bean);
            double radius = null != beanRadius ? beanRadius : (boundsWidth > boundsHeight ? boundsWidth / 2.0 : boundsHeight / 2.0);
            Double minRadius = this.minRadiusProvider.apply(bean);
            Double maxRadius = this.maxRadiusProvider.apply(bean);
            if (radius > 0.0) {
                ((HasRadius)view).setRadius(radius);
            }
            if (SizeHandler.isValidSizeConstraint(minRadius)) {
                ((HasRadius)view).setMinRadius(minRadius);
            }
            if (SizeHandler.isValidSizeConstraint(maxRadius)) {
                ((HasRadius)view).setMaxRadius(maxRadius);
            }
        }
    }

    private static boolean isValidSizeConstraint(Double value) {
        if (value == null) {
            return true;
        }
        return value > 0.0;
    }

    public static class Builder<W, V extends ShapeView> {
        private Function<W, Double> widthProvider = value -> null;
        private Function<W, Double> minWidthProvider = value -> 25.0;
        private Function<W, Double> maxWidthProvider = value -> 30000.0;
        private Function<W, Double> heightProvider = value -> null;
        private Function<W, Double> minHeightProvider = value -> 25.0;
        private Function<W, Double> maxHeightProvider = value -> 3000.0;
        private Function<W, Double> radiusProvider = value -> null;
        private Function<W, Double> minRadiusProvider = value -> 10.0;
        private Function<W, Double> maxRadiusProvider = value -> 3000.0;

        public Builder<W, V> width(Function<W, Double> provider) {
            this.widthProvider = provider;
            return this;
        }

        public Builder<W, V> minWidth(Function<W, Double> provider) {
            this.minWidthProvider = provider;
            return this;
        }

        public Builder<W, V> maxWidth(Function<W, Double> provider) {
            this.maxWidthProvider = provider;
            return this;
        }

        public Builder<W, V> height(Function<W, Double> provider) {
            this.heightProvider = provider;
            return this;
        }

        public Builder<W, V> minHeight(Function<W, Double> provider) {
            this.minHeightProvider = provider;
            return this;
        }

        public Builder<W, V> maxHeight(Function<W, Double> provider) {
            this.maxHeightProvider = provider;
            return this;
        }

        public Builder<W, V> radius(Function<W, Double> provider) {
            this.radiusProvider = provider;
            return this;
        }

        public Builder<W, V> minRadius(Function<W, Double> provider) {
            this.minRadiusProvider = provider;
            return this;
        }

        public Builder<W, V> maxRadius(Function<W, Double> provider) {
            this.maxRadiusProvider = provider;
            return this;
        }

        public SizeHandler<W, V> build() {
            return new SizeHandler(this.widthProvider, this.minWidthProvider, this.maxWidthProvider, this.heightProvider, this.minHeightProvider, this.maxHeightProvider, this.radiusProvider, this.minRadiusProvider, this.maxRadiusProvider);
        }
    }
}

