/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape.view.handler;

import java.util.function.Function;
import org.kie.workbench.common.stunner.core.client.shape.view.HasFillGradient;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeViewHandler;

public class ViewAttributesHandler<W, V extends ShapeView>
implements ShapeViewHandler<W, V> {
    private final Function<W, Double> alphaProvider;
    private final Function<W, String> fillColorProvider;
    private final Function<W, Double> fillAlphaProvider;
    private final Function<W, String> strokeColorProvider;
    private final Function<W, Double> strokeWidthProvider;
    private final Function<W, Double> strokeAlphaProvider;

    private ViewAttributesHandler(Function<W, Double> alphaProvider, Function<W, String> fillColorProvider, Function<W, Double> fillAlphaProvider, Function<W, String> strokeColorProvider, Function<W, Double> strokeWidthProvider, Function<W, Double> strokeAlphaProvider) {
        this.alphaProvider = alphaProvider;
        this.fillColorProvider = fillColorProvider;
        this.fillAlphaProvider = fillAlphaProvider;
        this.strokeColorProvider = strokeColorProvider;
        this.strokeWidthProvider = strokeWidthProvider;
        this.strokeAlphaProvider = strokeAlphaProvider;
    }

    public void handle(W element, V view) {
        Double strokeAlpha;
        Double strokeWidth;
        String strokeColor;
        Double fillAlpha;
        String color;
        Double alpha = this.alphaProvider.apply(element);
        if (null != alpha) {
            view.setAlpha(alpha.doubleValue());
        }
        if ((color = this.fillColorProvider.apply(element)) != null && color.trim().length() > 0) {
            boolean hasGradient = view instanceof HasFillGradient;
            if (!hasGradient) {
                view.setFillColor(color);
            } else {
                ((HasFillGradient)view).setFillGradient(HasFillGradient.Type.LINEAR, color, "#FFFFFF");
            }
        }
        if (null != (fillAlpha = this.fillAlphaProvider.apply(element))) {
            view.setFillAlpha(fillAlpha.doubleValue());
        }
        if ((strokeColor = this.strokeColorProvider.apply(element)) != null && strokeColor.trim().length() > 0) {
            view.setStrokeColor(strokeColor);
        }
        if ((strokeWidth = this.strokeWidthProvider.apply(element)) != null) {
            view.setStrokeWidth(strokeWidth.doubleValue());
        }
        if (null != (strokeAlpha = this.strokeAlphaProvider.apply(element))) {
            view.setStrokeAlpha(strokeAlpha.doubleValue());
        }
    }

    public static class Builder<W, V extends ShapeView> {
        private Function<W, Double> alphaProvider = value -> null;
        private Function<W, String> fillColorProvider = value -> null;
        private Function<W, Double> fillAlphaProvider = value -> null;
        private Function<W, String> strokeColorProvider = value -> null;
        private Function<W, Double> strokeWidthProvider = value -> null;
        private Function<W, Double> strokeAlphaProvider = value -> null;

        public Builder<W, V> alpha(Function<W, Double> alphaProvider) {
            this.alphaProvider = alphaProvider;
            return this;
        }

        public Builder<W, V> fillColor(Function<W, String> provider) {
            this.fillColorProvider = provider;
            return this;
        }

        public Builder<W, V> fillAlpha(Function<W, Double> provider) {
            this.fillAlphaProvider = provider;
            return this;
        }

        public Builder<W, V> strokeColor(Function<W, String> provider) {
            this.strokeColorProvider = provider;
            return this;
        }

        public Builder<W, V> strokeWidth(Function<W, Double> provider) {
            this.strokeWidthProvider = provider;
            return this;
        }

        public Builder<W, V> strokeAlpha(Function<W, Double> provider) {
            this.strokeAlphaProvider = provider;
            return this;
        }

        public ViewAttributesHandler<W, V> build() {
            return new ViewAttributesHandler(this.alphaProvider, this.fillColorProvider, this.fillAlphaProvider, this.strokeColorProvider, this.strokeWidthProvider, this.strokeAlphaProvider);
        }
    }
}

