/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Stream;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.impl.ConnectorShape;
import org.kie.workbench.common.stunner.core.client.shape.view.BoundingBox;
import org.kie.workbench.common.stunner.core.client.shape.view.HasDragBounds;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.ControlPoint;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.Point2D;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.AbstractChildrenTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.content.ChildrenTraverseProcessorImpl;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessorImpl;

public class ShapeUtils {
    public static void applyConnections(Edge<?, ?> edge, CanvasHandler canvasHandler, MutationContext mutationContext) {
        Canvas canvas = canvasHandler.getCanvas();
        Node sourceNode = edge.getSourceNode();
        Node targetNode = edge.getTargetNode();
        Shape source = sourceNode != null ? canvas.getShape(sourceNode.getUUID()) : null;
        Shape target = targetNode != null ? canvas.getShape(targetNode.getUUID()) : null;
        EdgeShape connector = (EdgeShape)canvas.getShape(edge.getUUID());
        connector.applyConnections(edge, source != null ? source.getShapeView() : null, target != null ? target.getShapeView() : null, mutationContext);
    }

    public static List<ControlPoint> addControlPoints(Edge edge, CanvasHandler canvasHandler, ControlPoint ... controlPoints) {
        return ShapeUtils.getConnectorShape(edge, canvasHandler).addControlPoints(controlPoints);
    }

    private static ConnectorShape getConnectorShape(Edge edge, CanvasHandler canvasHandler) {
        ShapeUtils.validateConnector(edge);
        return (ConnectorShape)canvasHandler.getCanvas().getShape(edge.getUUID());
    }

    public static void removeControlPoints(Edge edge, CanvasHandler canvasHandler, ControlPoint ... controlPoints) {
        ShapeUtils.getConnectorShape(edge, canvasHandler).removeControlPoints(controlPoints);
    }

    public static void updateControlPoint(Edge edge, CanvasHandler canvasHandler, ControlPoint controlPoint) {
        ShapeUtils.getConnectorShape(edge, canvasHandler).updateControlPoint(controlPoint);
    }

    public static List<ControlPoint> getControlPoints(Edge edge, CanvasHandler canvasHandler) {
        return ShapeUtils.getConnectorShape(edge, canvasHandler).getControlPoints();
    }

    public static void hideControlPoints(Edge edge, CanvasHandler canvasHandler) {
        ShapeUtils.getConnectorShape(edge, canvasHandler).applyState(ShapeState.NONE);
    }

    public static void showControlPoints(Edge edge, CanvasHandler canvasHandler) {
        ShapeUtils.getConnectorShape(edge, canvasHandler).applyState(ShapeState.SELECTED);
    }

    private static void validateConnector(Edge edge) {
        Objects.requireNonNull(edge, "Edge should not be null");
        if (!(edge.getContent() instanceof ViewConnector)) {
            throw new IllegalArgumentException("Edge content should be a ViewConnector. Edge UUID: " + edge.getUUID());
        }
    }

    public static void updateEdgeConnections(Edge<? extends ViewConnector<?>, Node> edge, AbstractCanvasHandler context) {
        Node source = edge.getSourceNode();
        Node target = edge.getTargetNode();
        ((ViewConnector)edge.getContent()).getSourceConnection().ifPresent(connection -> ShapeUtils.updateEdgeConnection(context, connection, source));
        ((ViewConnector)edge.getContent()).getTargetConnection().ifPresent(connection -> ShapeUtils.updateEdgeConnection(context, connection, target));
    }

    public static void updateEdgeConnection(AbstractCanvasHandler context, Connection connection, Node<? extends View<?>, Edge> node) {
        MagnetConnection magnetConnection;
        OptionalInt magnetIndex;
        if (null != node && null == connection.getLocation() && connection instanceof MagnetConnection && (magnetIndex = (magnetConnection = (MagnetConnection)connection).getMagnetIndex()).orElse(-1) == 0) {
            Shape nodeShape = context.getCanvas().getShape(node.getUUID());
            BoundingBox boundingBox = nodeShape.getShapeView().getBoundingBox();
            magnetConnection.setLocation(new Point2D(boundingBox.getWidth() / 2.0, boundingBox.getHeight() / 2.0));
        }
    }

    public static void enforceLocationConstraints(ShapeView shape, Bounds bounds) {
        if (shape instanceof HasDragBounds) {
            ((HasDragBounds)shape).setDragBounds(bounds);
        }
    }

    public static void moveViewConnectorsToTop(AbstractCanvasHandler canvasHandler, Node<?, Edge> node) {
        final HashSet<String> connectorIds = new HashSet<String>();
        ShapeUtils.appendViewConnectorIds(connectorIds, node);
        new ChildrenTraverseProcessorImpl((TreeWalkTraverseProcessor)new TreeWalkTraverseProcessorImpl()).setRootUUID(node.getUUID()).traverse((Object)canvasHandler.getGraphIndex().getGraph(), (Object)new AbstractChildrenTraverseCallback<Node<View, Edge>, Edge<Child, Node>>(){

            public boolean startNodeTraversal(List<Node<View, Edge>> parents, Node<View, Edge> childNode) {
                ShapeUtils.appendViewConnectorIds(connectorIds, childNode);
                return true;
            }
        });
        connectorIds.forEach(id -> ShapeUtils.moveShapeToTop(canvasHandler, id));
    }

    public static double dist(double x0, double y0, double x1, double y1) {
        double dx = Math.abs(x1 - x0);
        double dy = Math.abs(y1 - y0);
        return Math.sqrt(dx * dx + dy * dy);
    }

    private static void appendViewConnectorIds(Set<String> result, Node<?, Edge> node) {
        Stream.concat(node.getInEdges().stream(), node.getOutEdges().stream()).filter(e -> e.getContent() instanceof ViewConnector).forEach(e -> result.add(e.getUUID()));
    }

    private static void moveShapeToTop(AbstractCanvasHandler canvasHandler, String uuid) {
        Shape shape = canvasHandler.getCanvas().getShape(uuid);
        if (null != shape) {
            shape.getShapeView().moveToTop();
        }
    }
}

