/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.util;

import com.google.gwt.core.client.GWT;
import com.google.gwt.logging.client.LogConfiguration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractSession;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.PropertySetAdapter;
import org.kie.workbench.common.stunner.core.definition.property.PropertyType;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.Bound;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

public class StunnerClientLogger {
    private static Logger LOGGER = Logger.getLogger(StunnerClientLogger.class.getName());
    private static final Level[] LOG_LEVELS = new Level[]{Level.FINEST, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE};

    public static String getErrorMessage(ClientRuntimeError error) {
        Throwable t2;
        String message = error.getMessage();
        Throwable t1 = error.getThrowable();
        Throwable throwable = t2 = t1 != null ? t1.getCause() : null;
        if (null != t2) {
            return t2.getMessage();
        }
        if (null != t1) {
            return t1.getMessage();
        }
        return null != message ? message : " -- No message -- ";
    }

    public static void logDefinition(DefinitionManager definitionManager, Object def) {
        DefinitionAdapter defAdapter = definitionManager.adapters().registry().getDefinitionAdapter(def.getClass());
        String id = defAdapter.getId(def).value();
        String category = defAdapter.getCategory(def);
        String description = defAdapter.getDescription(def);
        String title = defAdapter.getTitle(def);
        Set labels = defAdapter.getLabels(def);
        HashSet propertiesVisited = new HashSet();
        GWT.log((String)"");
        GWT.log((String)"********************************************************");
        GWT.log((String)("ID = " + id));
        GWT.log((String)("CATEGORY = " + category));
        GWT.log((String)("DESC = " + description));
        GWT.log((String)("TITLE = " + title));
        GWT.log((String)("LABELS = " + labels));
        defAdapter.getPropertySets(def).forEach(propSet -> StunnerClientLogger.logPropertySet(definitionManager, propSet, propertiesVisited));
        defAdapter.getProperties(def).stream().filter(prop -> !propertiesVisited.contains(prop)).forEach(prop -> StunnerClientLogger.logProperty(definitionManager, prop, new HashSet<Object>()));
        GWT.log((String)"********************************************************");
        GWT.log((String)"");
    }

    public static void logPropertySet(DefinitionManager definitionManager, Object propSet, Set<Object> propertiesVisited) {
        PropertySetAdapter adapter = definitionManager.adapters().registry().getPropertySetAdapter(propSet.getClass());
        String id = adapter.getId(propSet);
        String name = adapter.getName(propSet);
        GWT.log((String)"    ==================================================");
        GWT.log((String)("    ID = " + id));
        GWT.log((String)("    NAME = " + name));
        Set properties = adapter.getProperties(propSet);
        properties.forEach(prop -> StunnerClientLogger.logProperty(definitionManager, prop, propertiesVisited));
        GWT.log((String)"    ==================================================");
    }

    public static void logProperty(DefinitionManager definitionManager, Object prop, Set<Object> propertiesVisited) {
        PropertyAdapter adapter = definitionManager.adapters().registry().getPropertyAdapter(prop.getClass());
        String id = adapter.getId(prop);
        String caption = adapter.getCaption(prop);
        String description = adapter.getDescription(prop);
        PropertyType type = adapter.getType(prop);
        Object value = adapter.getValue(prop);
        GWT.log((String)"    -------------------------------------------------");
        GWT.log((String)("    ID = " + id));
        GWT.log((String)("    CAPTION = " + caption));
        GWT.log((String)("    DESC = " + description));
        GWT.log((String)("    TYPE = " + type));
        GWT.log((String)("    VALUE = " + value));
        GWT.log((String)"    -------------------------------------------------");
        propertiesVisited.add(prop);
    }

    public static void logBounds(Element<? extends View<?>> item) {
        Bounds bounds = ((View)item.getContent()).getBounds();
        Bound ul = bounds.getUpperLeft();
        Bound lr = bounds.getLowerRight();
        LOGGER.log(Level.FINE, "Bounds for [" + item.getUUID() + "] ARE { UL=[" + ul.getX() + ", " + ul.getY() + "] LR=[ " + lr.getX() + ", " + lr.getY() + "] }");
        LOGGER.log(Level.FINE, "Bound attributes for [" + item.getUUID() + "] ARE [X=" + ul.getX() + ", Y=" + ul.getY() + "] [W=[ " + (lr.getX() - ul.getX()) + ", H=" + (lr.getY() - ul.getY()) + "] }");
    }

    public static void logSessionInfo(AbstractSession session) {
        StunnerClientLogger.log("************ Session Info ****************");
        if (null != session) {
            StunnerClientLogger.log("Session = " + session.toString());
            StunnerClientLogger.log("Session id = " + session.getSessionUUID());
            StunnerClientLogger.log("Canvas = " + session.getCanvas().toString());
            if (null != session.getCanvasHandler()) {
                CanvasHandler canvasHandler = session.getCanvasHandler();
                StunnerClientLogger.log("CanvasHandler = " + canvasHandler.toString());
                Diagram diagram = canvasHandler.getDiagram();
                if (null != diagram) {
                    StunnerClientLogger.log("Diagram name = " + diagram.getName());
                    StunnerClientLogger.log("Graph uuid = " + (null != diagram.getGraph() ? diagram.getGraph().getUUID() : "null"));
                    Metadata metadata = diagram.getMetadata();
                    if (null != metadata) {
                        StunnerClientLogger.log("Metadata defSetId = " + metadata.getDefinitionSetId());
                        StunnerClientLogger.log("Metadata profileId = " + metadata.getProfileId());
                        StunnerClientLogger.log("Metadata shapeSetId = " + metadata.getShapeSetId());
                        StunnerClientLogger.log("Metadata canvas root = " + metadata.getCanvasRootUUID());
                        StunnerClientLogger.log("Metadata title = " + metadata.getTitle());
                    } else {
                        StunnerClientLogger.log("Metadata = null");
                    }
                } else {
                    StunnerClientLogger.log("Diagram = null");
                }
            } else {
                StunnerClientLogger.log("CanvasHandler = null");
            }
            if (session instanceof EditorSession) {
                StunnerClientLogger.logFullSessionInfo((EditorSession)session);
            }
        } else {
            StunnerClientLogger.log("Session is null");
        }
        StunnerClientLogger.log("******************************************");
    }

    private static void logFullSessionInfo(EditorSession session) {
        CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager = session.getCommandManager();
        StunnerClientLogger.log("Canvas command mgr = " + (null != canvasCommandManager ? canvasCommandManager.toString() : "null"));
    }

    public static void logCommandHistory(EditorSession session) {
        if (null != session) {
            List history = session.getCommandRegistry().getCommandHistory();
            StunnerClientLogger.logCommandHistory(history);
        }
    }

    private static void logCommandHistory(List<Command<AbstractCanvasHandler, CanvasViolation>> history) {
        StunnerClientLogger.log("**** COMMAND HISTORY START *********");
        if (null == history) {
            StunnerClientLogger.log("History is null");
        } else {
            int[] x = new int[]{0};
            history.stream().forEach(command -> {
                StunnerClientLogger.logCommand(x[0], (Command<AbstractCanvasHandler, CanvasViolation>)command);
                x[0] = x[0] + 1;
            });
            StunnerClientLogger.log(" ( FOUND " + x[0] + " ENTRIES )");
        }
        StunnerClientLogger.log("**** COMMAND HISTORY END *********");
    }

    private static void logCommand(int count, Command<AbstractCanvasHandler, CanvasViolation> command) {
        if (null == command) {
            StunnerClientLogger.log("Command is null");
        } else {
            StunnerClientLogger.log("Command [" + count + "] => " + command.toString());
        }
    }

    public static void switchLogLevel() {
        Level level = Logger.getLogger("org.kie.workbench.common.stunner").getLevel();
        int idx = StunnerClientLogger.getLevelIndex(level);
        Level newLevel = idx > -1 && idx + 1 < LOG_LEVELS.length ? LOG_LEVELS[idx + 1] : LOG_LEVELS[0];
        GWT.log((String)("*** Switching to log level: " + newLevel.toString()));
        Logger.getLogger("org.kie.workbench.common.stunner").setLevel(newLevel);
    }

    private static int getLevelIndex(Level level) {
        int idx = -1;
        if (null != level) {
            for (Level l : LOG_LEVELS) {
                if (level.equals(l)) {
                    return idx + 1;
                }
                ++idx;
            }
        }
        return idx;
    }

    public static void log(String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(Level.INFO, message);
        }
    }

    public static void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

