/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.TextPropertyProviderFactory;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.shape.ElementShape;
import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.ParameterizedCommand;

public abstract class BaseCanvasHandler<D extends Diagram, C extends AbstractCanvas>
extends AbstractCanvasHandler<D, C> {
    private static Logger LOGGER = Logger.getLogger(BaseCanvasHandler.class.getName());
    private final DefinitionManager definitionManager;
    private final GraphUtils graphUtils;
    private final ShapeManager shapeManager;
    private final TextPropertyProviderFactory textPropertyProviderFactory;
    private C canvas;
    private D diagram;
    private RuleSet ruleSet;

    public BaseCanvasHandler(DefinitionManager definitionManager, GraphUtils graphUtils, ShapeManager shapeManager, TextPropertyProviderFactory textPropertyProviderFactory) {
        this.definitionManager = definitionManager;
        this.graphUtils = graphUtils;
        this.shapeManager = shapeManager;
        this.textPropertyProviderFactory = textPropertyProviderFactory;
    }

    protected abstract void buildGraphIndex(Command var1);

    public abstract void draw(ParameterizedCommand<CommandResult> var1);

    protected abstract void destroyGraphIndex(Command var1);

    public CanvasHandler<D, C> handle(C canvas) {
        this.canvas = canvas;
        return this;
    }

    public void draw(D diagram, ParameterizedCommand<CommandResult> loadCallback) {
        if (null == this.canvas) {
            throw new IllegalStateException("No handled canvas instance.");
        }
        this.diagram = diagram;
        this.buildGraphIndex(() -> this.loadRuleSet(() -> this.draw(loadCallback)));
    }

    @Override
    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    public C getCanvas() {
        return this.canvas;
    }

    public D getDiagram() {
        return this.diagram;
    }

    protected void loadRuleSet(Command callback) {
        String id = this.getDiagram().getMetadata().getDefinitionSetId();
        Object defSet = this.getDefinitionManager().definitionSets().getDefinitionSetById(id);
        this.ruleSet = this.definitionManager.adapters().forRules().getRuleSet(defSet);
        callback.execute();
    }

    @Override
    public ShapeFactory<Object, Shape> getShapeFactory(String shapeSetId) {
        ShapeSet shapeSet = this.shapeManager.getShapeSet(shapeSetId);
        if (null == shapeSet) {
            LOGGER.log(Level.SEVERE, "ShapeSet [" + shapeSetId + "] not found. Using the default one,.");
        }
        shapeSet = this.shapeManager.getDefaultShapeSet(this.diagram.getMetadata().getDefinitionSetId());
        return shapeSet.getShapeFactory();
    }

    @Override
    public void register(Shape shape, Element<View<?>> candidate, boolean fireEvents) {
        this.addShape(shape);
        if (fireEvents) {
            this.notifyCanvasElementAdded(candidate);
            this.afterElementAdded(candidate, shape);
        }
    }

    @Override
    public void deregister(Shape shape, Element element, boolean fireEvents) {
        if (fireEvents) {
            this.notifyCanvasElementRemoved(element);
            this.beforeElementDeleted(element, shape);
        }
        this.removeShape(shape);
        if (fireEvents) {
            this.afterElementDeleted(element, shape);
        }
    }

    public void addShape(Shape shape) {
        this.getCanvas().addShape(shape);
    }

    public void removeShape(Shape shape) {
        this.getCanvas().deleteShape(shape);
    }

    @Override
    public void applyElementMutation(Shape shape, Element candidate, boolean applyPosition, boolean applyProperties, MutationContext mutationContext) {
        if (shape instanceof ElementShape) {
            ElementShape graphShape = (ElementShape)shape;
            this.applyElementMutation(graphShape, candidate, applyPosition, applyProperties, mutationContext);
        } else {
            LOGGER.log(Level.WARNING, "The shape to handle must be type of [" + ElementShape.class.getName() + "]");
        }
    }

    protected void applyElementMutation(ElementShape graphShape, Element candidate, boolean applyPosition, boolean applyProperties, MutationContext mutationContext) {
        if (applyPosition) {
            graphShape.applyPosition(candidate, mutationContext);
        }
        if (applyProperties) {
            this.applyElementTitle(graphShape, candidate, mutationContext);
            graphShape.applyProperties((Object)candidate, mutationContext);
        }
        this.applyElementMutation((Shape)graphShape, candidate);
    }

    protected void applyElementMutation(Shape shape, Element candidate) {
        this.beforeDraw(candidate, shape);
        this.beforeElementUpdated(candidate, shape);
        this.afterDraw(candidate, shape);
        this.notifyCanvasElementUpdated(candidate);
        this.afterElementUpdated(candidate, shape);
    }

    protected void applyElementTitle(ElementShape shape, Element candidate, MutationContext mutationContext) {
        TextPropertyProvider textPropertyProvider = this.textPropertyProviderFactory.getProvider((Element<? extends Definition>)candidate);
        String name = textPropertyProvider.getText((Element<? extends Definition>)candidate);
        shape.applyTitle(name, candidate, mutationContext);
    }

    protected void beforeDraw(Element element, Shape shape) {
        if (shape instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)shape;
            lifecycle.beforeDraw();
        }
    }

    protected void afterDraw(Element element, Shape shape) {
        if (shape instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)shape;
            lifecycle.afterDraw();
        }
    }

    @Override
    public void addChild(Element parent, Element child) {
        Shape childShape = this.getCanvas().getShape(child.getUUID());
        if (!this.isCanvasRoot(parent)) {
            Shape parentShape = this.getCanvas().getShape(parent.getUUID());
            this.getCanvas().addChild(parentShape, childShape);
        } else {
            this.getCanvas().addChild(childShape);
        }
    }

    @Override
    public void addChild(Element parent, Element child, int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeChild(Element parent, Element child) {
        String parentUUID = parent.getUUID();
        String childUUID = child.getUUID();
        Shape childShape = this.getCanvas().getShape(childUUID);
        if (Objects.isNull(childShape)) {
            return;
        }
        if (!this.isCanvasRoot(parentUUID)) {
            Shape parentShape = this.getCanvas().getShape(parentUUID);
            if (Objects.isNull(parentShape)) {
                return;
            }
            this.getCanvas().deleteChild(parentShape, childShape);
        } else {
            this.getCanvas().deleteChild(childShape);
        }
    }

    @Override
    public Optional<Element> getElementAt(double x, double y) {
        Optional shape = this.getCanvas().getShapeAt(x, y);
        return shape.flatMap(s -> this.getElement(s.getUUID()));
    }

    protected Optional<Element> getElement(String uuid) {
        return Optional.of(this.getGraphIndex().getNode(uuid));
    }

    protected boolean isCanvasRoot(String pUUID) {
        return CanvasLayoutUtils.isCanvasRoot(this.getDiagram(), pUUID);
    }

    @Override
    public boolean dock(Element parent, Element child) {
        if (!this.isCanvasRoot(parent)) {
            Shape parentShape = this.getCanvas().getShape(parent.getUUID());
            Shape childShape = this.getCanvas().getShape(child.getUUID());
            try {
                this.getCanvas().dock(parentShape, childShape);
                return true;
            }
            catch (Exception e) {
                LOGGER.fine("Error docking node " + child.getUUID());
                return false;
            }
        }
        return false;
    }

    @Override
    public void undock(Element target, Element child) {
        String targetUUID = target.getUUID();
        String childUUID = child.getUUID();
        if (!this.isCanvasRoot(targetUUID)) {
            Shape targetShape = this.getCanvas().getShape(targetUUID);
            Shape childShape = this.getCanvas().getShape(childUUID);
            if (Objects.nonNull(targetShape) && Objects.nonNull(childShape)) {
                this.getCanvas().undock(targetShape, childShape);
            }
        }
    }

    protected void afterElementAdded(Element element, Shape shape) {
    }

    protected void beforeElementDeleted(Element element, Shape shape) {
    }

    protected void afterElementDeleted(Element element, Shape shape) {
    }

    protected void beforeElementUpdated(Element element, Shape shape) {
    }

    protected void afterElementUpdated(Element element, Shape shape) {
    }

    @Override
    public CanvasHandler<D, C> doClear() {
        this.destroyGraph(() -> {
            this.diagram = null;
            this.ruleSet = null;
        });
        return this;
    }

    @Override
    public void doDestroy() {
        this.destroyGraph(() -> {
            this.canvas = null;
            this.diagram = null;
            this.ruleSet = null;
        });
    }

    protected void destroyGraph(Command callback) {
        this.destroyGraphIndex(() -> {
            if (null != this.diagram && null != this.diagram.getGraph()) {
                this.diagram.getGraph().clear();
            }
            callback.execute();
        });
    }

    protected void showError(ClientRuntimeError error) {
        String message = error.getThrowable() != null ? error.getThrowable().getMessage() : error.getMessage();
        this.log(Level.SEVERE, message);
    }

    @Override
    public DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    @Override
    public TextPropertyProviderFactory getTextPropertyProviderFactory() {
        return this.textPropertyProviderFactory;
    }

    public GraphUtils getGraphUtils() {
        return this.graphUtils;
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    protected String getDefinitionId(Object definition) {
        return this.getDefinitionManager().adapters().forDefinition().getId(definition).value();
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

