/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolationImpl;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.DockingRuleViolation;

public class AddCanvasDockedNodeCommand
extends AbstractCanvasCommand {
    private final Node parent;
    private final Node candidate;
    private final String ssid;

    public AddCanvasDockedNodeCommand(Node parent, Node candidate, String ssid) {
        this.parent = parent;
        this.candidate = candidate;
        this.ssid = ssid;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        context.register(this.ssid, (Element<View<?>>)this.candidate);
        context.applyElementMutation((Element)this.candidate, MutationContext.STATIC);
        context.applyElementMutation((Element)this.parent, MutationContext.STATIC);
        if (!context.dock((Element)this.parent, (Element)this.candidate)) {
            return new CanvasCommandResultBuilder().addViolation(CanvasViolationImpl.Builder.build((RuleViolation)new DockingRuleViolation(this.parent.getUUID(), this.candidate.getUUID()))).build();
        }
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        return new DeleteCanvasNodeCommand(this.candidate, this.parent).execute(context);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [parent=" + AddCanvasDockedNodeCommand.toUUID(this.parent) + ",candidate=" + AddCanvasDockedNodeCommand.toUUID(this.candidate) + ",shapeSet=" + this.ssid + "]";
    }
}

