/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCompositeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateChildrenCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

public class UpdateDockNodeCommand
extends AbstractCanvasCompositeCommand {
    private final Node parent;
    private final Node candidate;
    private boolean adjustPosition;

    public UpdateDockNodeCommand(Node parent, Node candidate) {
        this(parent, candidate, false);
    }

    public UpdateDockNodeCommand(Node parent, Node candidate, boolean adjustPosition) {
        this.parent = parent;
        this.candidate = candidate;
        this.adjustPosition = adjustPosition;
    }

    protected AbstractCompositeCommand<AbstractCanvasHandler, CanvasViolation> initialize(AbstractCanvasHandler context) {
        boolean mustUpdateParent;
        super.initialize((Object)context);
        Optional<Edge<?, Node>> dockEdge = this.getEdge(this.candidate.getInEdges(), e -> e.getContent() instanceof Dock);
        Optional<Edge<?, Node>> childEdge = this.getEdge(this.candidate.getInEdges(), e -> e.getContent() instanceof Child);
        Element<?> parentParent = this.getParentOfParent(context, this.parent);
        boolean bl = mustUpdateParent = Objects.nonNull(parentParent) && childEdge.filter(e -> !parentParent.equals(e.getSourceNode())).isPresent();
        if (mustUpdateParent) {
            this.addCommand((Command)new UpdateChildrenCommand((Node)parentParent, this.candidate));
        } else {
            dockEdge.ifPresent(e -> this.addCommand((Command)new UnDockNodeCommand(e.getSourceNode(), this.candidate)));
        }
        this.addCommand((Command)new DockNodeCommand(this.parent, this.candidate, this.adjustPosition));
        return this;
    }

    private Element<?> getParentOfParent(AbstractCanvasHandler context, Node parent) {
        Element parentOfParent = GraphUtils.getParent((Node)parent);
        return GraphUtils.isRootNode((Element)parentOfParent, (Graph)context.getGraphIndex().getGraph()) ? context.getGraphIndex().getNode(context.getDiagram().getMetadata().getCanvasRootUUID()) : parentOfParent;
    }

    protected Optional<Edge<?, Node>> getEdge(List<Edge<?, Node>> edges, Predicate<Edge> predicate) {
        if (null != edges) {
            return edges.stream().filter(predicate).findAny();
        }
        return Optional.empty();
    }

    public Node getParent() {
        return this.parent;
    }

    public Node getCandidate() {
        return this.candidate;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [parent=" + AbstractCanvasCommand.toUUID(this.parent) + ",candidate=" + AbstractCanvasCommand.toUUID(this.candidate) + "]";
    }
}

