/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasGraphCommand;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandResultBuilder;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.domainobject.DomainObject;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.impl.UpdateDomainObjectPropertyValueCommand;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

public class UpdateDomainObjectPropertyCommand
extends AbstractCanvasGraphCommand {
    private final DomainObject domainObject;
    private final String propertyId;
    private final Object value;

    public UpdateDomainObjectPropertyCommand(DomainObject domainObject, String propertyId, Object value) {
        this.domainObject = domainObject;
        this.propertyId = propertyId;
        this.value = value;
    }

    @Override
    protected Command<GraphCommandExecutionContext, RuleViolation> newGraphCommand(AbstractCanvasHandler context) {
        return new UpdateDomainObjectPropertyValueCommand(this.domainObject, this.propertyId, this.value);
    }

    protected AbstractCanvasCommand newCanvasCommand(AbstractCanvasHandler context) {
        return new RefreshPropertiesPanelCommand();
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [domainObject=" + this.domainObject.getDomainObjectUUID() + ",propertyId=" + this.propertyId + ",value=" + this.value + "]";
    }

    public class RefreshPropertiesPanelCommand
    extends AbstractCanvasCommand {
        public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
            context.notifyCanvasDomainObjectUpdated(UpdateDomainObjectPropertyCommand.this.domainObject);
            return CanvasCommandResultBuilder.SUCCESS;
        }

        public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
            context.notifyCanvasDomainObjectUpdated(UpdateDomainObjectPropertyCommand.this.domainObject);
            return CanvasCommandResultBuilder.SUCCESS;
        }
    }
}

