/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.util;

import java.util.Collections;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasPanel;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolationImpl;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.CommandResultImpl;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;
import org.kie.workbench.common.stunner.core.rule.violations.BoundsExceededViolation;

public class CanvasUtils {
    public static boolean areBoundsExceeded(AbstractCanvasHandler canvasHandler, Bounds bounds) {
        CanvasPanel canvasPanel = canvasHandler.getAbstractCanvas().getView().getPanel();
        return !GraphUtils.checkBoundsExceeded((Bounds)canvasPanel.getLocationConstraints(), (Bounds)bounds);
    }

    public static CommandResult<CanvasViolation> createBoundsExceededCommandResult(AbstractCanvasHandler canvasHandler, Bounds bounds) {
        CanvasViolation cv = CanvasViolationImpl.Builder.build((RuleViolation)new BoundsExceededViolation(bounds).setUUID(canvasHandler.getUuid()));
        return new CommandResultImpl(CommandResult.Type.WARNING, Collections.singleton(cv));
    }
}

