/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.command;

import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.client.api.ClientFactoryManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandAllowedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.command.CanvasCommandUndoneEvent;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandListener;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.HasCommandListener;
import org.kie.workbench.common.stunner.core.command.impl.CommandManagerImpl;
import org.kie.workbench.common.stunner.core.graph.command.ContextualGraphCommandExecutionContext;

@Dependent
public class CanvasCommandManagerImpl<H extends AbstractCanvasHandler>
implements CanvasCommandManager<H>,
HasCommandListener<CommandListener<H, CanvasViolation>> {
    private final ClientFactoryManager clientFactoryManager;
    private final Event<CanvasCommandAllowedEvent> isCanvasCommandAllowedEvent;
    private final Event<CanvasCommandExecutedEvent> canvasCommandExecutedEvent;
    private final Event<CanvasCommandUndoneEvent> canvasUndoCommandExecutedEvent;
    private final CommandManager<H, CanvasViolation> commandManager;
    private CommandListener<H, CanvasViolation> listener;

    protected CanvasCommandManagerImpl() {
        this(null, null, null, null);
    }

    @Inject
    public CanvasCommandManagerImpl(ClientFactoryManager clientFactoryManager, Event<CanvasCommandAllowedEvent> isCanvasCommandAllowedEvent, Event<CanvasCommandExecutedEvent> canvasCommandExecutedEvent, Event<CanvasCommandUndoneEvent> canvasUndoCommandExecutedEvent) {
        this.clientFactoryManager = clientFactoryManager;
        this.isCanvasCommandAllowedEvent = isCanvasCommandAllowedEvent;
        this.canvasCommandExecutedEvent = canvasCommandExecutedEvent;
        this.canvasUndoCommandExecutedEvent = canvasUndoCommandExecutedEvent;
        this.commandManager = new CommandManagerImpl();
        this.listener = null;
    }

    public CommandResult<CanvasViolation> allow(H context, Command<H, CanvasViolation> command) {
        return this.runInContext((AbstractCanvasHandler)context, () -> this.postAllow(context, command, (CommandResult<CanvasViolation>)this.commandManager.allow((Object)context, command)));
    }

    public CommandResult<CanvasViolation> execute(H context, Command<H, CanvasViolation> command) {
        return this.runInContext((AbstractCanvasHandler)context, () -> this.postExecute(context, command, (CommandResult<CanvasViolation>)this.commandManager.execute((Object)context, command)));
    }

    public CommandResult<CanvasViolation> undo(H context, Command<H, CanvasViolation> command) {
        return this.runInContext((AbstractCanvasHandler)context, () -> this.postUndo(context, command, (CommandResult<CanvasViolation>)this.commandManager.undo((Object)context, command)));
    }

    public void setCommandListener(CommandListener<H, CanvasViolation> listener) {
        this.listener = listener;
    }

    private CommandResult<CanvasViolation> runInContext(AbstractCanvasHandler context, Supplier<CommandResult<CanvasViolation>> function) {
        ContextualGraphCommandExecutionContext graphExecutionContext = this.newGraphExecutionContext(context);
        context.setGraphExecutionContext(() -> this.newGraphExecutionContext(context));
        CommandResult<CanvasViolation> result = function.get();
        graphExecutionContext.clear();
        context.setGraphExecutionContext(() -> null);
        return result;
    }

    private ContextualGraphCommandExecutionContext newGraphExecutionContext(AbstractCanvasHandler context) {
        return new ContextualGraphCommandExecutionContext(context.getDefinitionManager(), (FactoryManager)this.clientFactoryManager, context.getRuleManager(), context.getGraphIndex(), context.getRuleSet());
    }

    private CommandResult<CanvasViolation> postAllow(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        if (null != this.listener) {
            this.listener.onAllow(context, command, result);
        }
        if (null != result && null != this.isCanvasCommandAllowedEvent) {
            this.isCanvasCommandAllowedEvent.fire((Object)new CanvasCommandAllowedEvent(context, command, result));
        }
        return result;
    }

    private CommandResult<CanvasViolation> postExecute(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        if (null != this.listener) {
            this.listener.onExecute(context, command, result);
        }
        if (null != result && null != this.canvasCommandExecutedEvent) {
            this.canvasCommandExecutedEvent.fire((Object)new CanvasCommandExecutedEvent(context, command, result));
        }
        return result;
    }

    private CommandResult<CanvasViolation> postUndo(H context, Command<H, CanvasViolation> command, CommandResult<CanvasViolation> result) {
        if (null != this.listener) {
            this.listener.onUndo(context, command, result);
        }
        if (null != this.canvasUndoCommandExecutedEvent) {
            this.canvasUndoCommandExecutedEvent.fire((Object)new CanvasCommandUndoneEvent(context, command, result));
        }
        return result;
    }
}

