/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.toolbox.actions;

import java.lang.annotation.Annotation;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractToolboxAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.FlowActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.GeneralCreateNodeAction;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.session.impl.InstanceUtils;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Dependent
@FlowActionsToolbox
public class CreateNodeToolboxAction
extends AbstractToolboxAction {
    static final String KEY_TITLE = "org.kie.workbench.common.stunner.core.client.toolbox.createNewNode";
    private final ManagedInstance<GeneralCreateNodeAction> actions;
    private String nodeId;
    private String edgeId;

    @Inject
    public CreateNodeToolboxAction(DefinitionUtils definitionUtils, ClientTranslationService translationService, @Any ManagedInstance<GeneralCreateNodeAction> actions) {
        super(definitionUtils, translationService);
        this.actions = actions;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public CreateNodeToolboxAction setNodeId(String nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    public CreateNodeToolboxAction setEdgeId(String edgeId) {
        this.edgeId = edgeId;
        return this;
    }

    @Override
    protected String getTitleKey(AbstractCanvasHandler canvasHandler, String uuid) {
        return KEY_TITLE;
    }

    @Override
    protected String getTitleDefinitionId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.nodeId;
    }

    @Override
    protected String getGlyphId(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.nodeId;
    }

    @Override
    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        Metadata metadata = canvasHandler.getDiagram().getMetadata();
        Annotation qualifier = this.getDefinitionUtils().getQualifier(metadata.getDefinitionSetId());
        GeneralCreateNodeAction action = InstanceUtils.lookup(this.actions, qualifier);
        action.executeAction(canvasHandler, uuid, this.nodeId, this.edgeId);
        return this;
    }

    @PreDestroy
    public void destroy() {
        this.nodeId = null;
        this.edgeId = null;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{this.edgeId.hashCode(), this.nodeId.hashCode()});
    }

    public boolean equals(Object o) {
        if (o instanceof CreateNodeToolboxAction) {
            CreateNodeToolboxAction other = (CreateNodeToolboxAction)o;
            return other.edgeId.equals(this.edgeId) && other.nodeId.equals(this.nodeId);
        }
        return false;
    }
}

