/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.components.views;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.components.views.FloatingView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.HandlerRegistrationImpl;
import org.uberfire.mvp.Command;

@Dependent
public class FloatingWidgetView
implements FloatingView<IsWidget> {
    private double ox = 0.0;
    private double oy = 0.0;
    private double x;
    private double y;
    private boolean attached = false;
    private Timer timer;
    private int timeout = 800;
    private boolean visible = false;
    private Command hideCallback;
    private final FlowPanel panel = new FlowPanel();
    private final HandlerRegistrationImpl handlerRegistrationManager = new HandlerRegistrationImpl();

    public FloatingWidgetView() {
        this.hideCallback = () -> {};
    }

    public void add(IsWidget item) {
        this.panel.add(item);
    }

    public FloatingView<IsWidget> setOffsetX(double ox) {
        this.ox = ox;
        return this;
    }

    public FloatingView<IsWidget> setOffsetY(double oy) {
        this.oy = oy;
        return this;
    }

    public FloatingWidgetView setX(double x) {
        this.x = x;
        return this;
    }

    public FloatingWidgetView setY(double y) {
        this.y = y;
        return this;
    }

    public FloatingWidgetView setTimeOut(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public FloatingView<IsWidget> clearTimeOut() {
        this.setTimeOut(-1);
        return this;
    }

    public FloatingView<IsWidget> setHideCallback(Command hideCallback) {
        PortablePreconditions.checkNotNull((String)"hideCallback", (Object)hideCallback);
        this.hideCallback = hideCallback;
        return this;
    }

    public void clear() {
        this.panel.clear();
    }

    public FloatingWidgetView show() {
        if (!this.visible) {
            this.visible = true;
            this.attach();
            this.startTimeout();
            this.panel.getElement().getStyle().setLeft(this.ox + this.x, Style.Unit.PX);
            this.panel.getElement().getStyle().setTop(this.oy + this.y, Style.Unit.PX);
            this.doShow();
        }
        return this;
    }

    public FloatingWidgetView hide() {
        if (this.visible) {
            this.visible = false;
            this.stopTimeout();
            this.doHide();
        }
        return this;
    }

    protected void doShow() {
        this.panel.getElement().getStyle().setDisplay(Style.Display.INLINE);
    }

    protected void doHide() {
        this.panel.getElement().getStyle().setDisplay(Style.Display.NONE);
        this.hideCallback.execute();
    }

    private void attach() {
        if (!this.attached) {
            RootPanel.get().add((Widget)this.panel);
            this.registerHoverEventHandlers();
            this.panel.getElement().getStyle().setPosition(Style.Position.FIXED);
            this.panel.getElement().getStyle().setZIndex(Integer.MAX_VALUE);
            this.doHide();
            this.attached = true;
        }
    }

    public void destroy() {
        this.stopTimeout();
        this.detach();
        this.timer = null;
        this.hideCallback = null;
    }

    private void detach() {
        if (this.attached) {
            this.handlerRegistrationManager.removeHandler();
            RootPanel.get().remove((Widget)this.panel);
            this.attached = false;
        }
    }

    public void startTimeout() {
        if (!(this.timeout <= 0 || null != this.timer && this.timer.isRunning())) {
            this.timer = new Timer(){

                public void run() {
                    FloatingWidgetView.this.hide();
                }
            };
            this.timer.schedule(this.timeout);
        }
    }

    public void stopTimeout() {
        if (null != this.timer && this.timer.isRunning()) {
            this.timer.cancel();
        }
    }

    protected FlowPanel getPanel() {
        return this.panel;
    }

    private void registerHoverEventHandlers() {
        this.handlerRegistrationManager.register(this.panel.addDomHandler((EventHandler)((MouseOverHandler)mouseOverEvent -> this.stopTimeout()), MouseOverEvent.getType()));
        this.handlerRegistrationManager.register(this.panel.addDomHandler((EventHandler)((MouseOutHandler)mouseOutEvent -> this.startTimeout()), MouseOutEvent.getType()));
    }
}

