/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.service;

import javax.enterprise.event.Event;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.stunner.core.client.api.ShapeManager;
import org.kie.workbench.common.stunner.core.client.service.ClientDiagramService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.command.event.SaveDiagramSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.lookup.LookupManager;
import org.kie.workbench.common.stunner.core.lookup.diagram.DiagramLookupRequest;
import org.kie.workbench.common.stunner.core.lookup.diagram.DiagramRepresentation;
import org.kie.workbench.common.stunner.core.service.BaseDiagramService;
import org.kie.workbench.common.stunner.core.service.DiagramLookupService;
import org.uberfire.backend.vfs.Path;

public abstract class AbstractClientDiagramService<M extends Metadata, D extends Diagram<Graph, M>, S extends BaseDiagramService<M, D>>
implements ClientDiagramService<M, D, S> {
    private final ShapeManager shapeManager;
    protected final Caller<S> diagramServiceCaller;
    protected final Caller<DiagramLookupService> diagramLookupServiceCaller;
    private final Event<SaveDiagramSessionCommandExecutedEvent> saveEvent;

    public AbstractClientDiagramService(ShapeManager shapeManager, Caller<S> diagramServiceCaller, Caller<DiagramLookupService> diagramLookupServiceCaller, Event<SaveDiagramSessionCommandExecutedEvent> saveEvent) {
        this.shapeManager = shapeManager;
        this.diagramServiceCaller = diagramServiceCaller;
        this.diagramLookupServiceCaller = diagramLookupServiceCaller;
        this.saveEvent = saveEvent;
    }

    @Override
    public void create(Path path, String name, String defSetId, ServiceCallback<Path> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(p -> callback.onSuccess((Object)path), (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).create(path, name, defSetId);
    }

    @Override
    public void saveOrUpdate(D diagram, ServiceCallback<D> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(serverMetadata -> {
            this.updateClientMetadata(diagram);
            diagram.getMetadata().setPath(((Metadata)serverMetadata).getPath());
            callback.onSuccess((Object)diagram);
            this.fireSavedEvent(diagram);
        }, (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).saveOrUpdate(diagram);
    }

    @Override
    public void saveOrUpdateSvg(Path diagramPath, String rawSvg, ServiceCallback<Path> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(res -> callback.onSuccess((Object)((Path)res)))).saveOrUpdateSvg(diagramPath, rawSvg);
    }

    protected void fireSavedEvent(D diagram) {
        this.saveEvent.fire((Object)new SaveDiagramSessionCommandExecutedEvent(diagram.getMetadata().getCanvasRootUUID()));
    }

    @Override
    public void add(D diagram, ServiceCallback<D> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(v -> {
            this.updateClientMetadata(diagram);
            callback.onSuccess((Object)diagram);
        }, (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).saveOrUpdate(diagram);
    }

    @Override
    public void getByPath(Path path, ServiceCallback<D> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(diagram -> {
            this.updateClientMetadata((Diagram)diagram);
            callback.onSuccess((Object)((Diagram)diagram));
        }, (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).getDiagramByPath(path);
    }

    @Override
    public void lookup(DiagramLookupRequest request, ServiceCallback<LookupManager.LookupResponse<DiagramRepresentation>> callback) {
        ((DiagramLookupService)this.diagramLookupServiceCaller.call(response -> callback.onSuccess((Object)((LookupManager.LookupResponse)response)), (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).lookup((LookupManager.LookupRequest)request);
    }

    @Override
    public void getRawContent(D diagram, ServiceCallback<String> callback) {
        ((BaseDiagramService)this.diagramServiceCaller.call(rawContent -> callback.onSuccess((Object)((String)rawContent)), (message, throwable) -> {
            callback.onError(new ClientRuntimeError(throwable));
            return false;
        })).getRawContent(diagram);
    }

    protected void updateClientMetadata(D diagram) {
        Metadata metadata;
        if (null != diagram && null != (metadata = diagram.getMetadata()) && AbstractClientDiagramService.isEmpty(metadata.getShapeSetId())) {
            String sId = this.shapeManager.getDefaultShapeSet(metadata.getDefinitionSetId()).getId();
            metadata.setShapeSetId(sId);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

