/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.command.SessionCommandManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.Session;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.ClearSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;

@Dependent
@Default
public class ClearSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    private static Logger LOGGER = Logger.getLogger(ClearSessionCommand.class.getName());
    private final ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance;
    private final SessionCommandManager<AbstractCanvasHandler> sessionCommandManager;
    private final Event<ClearSessionCommandExecutedEvent> commandExecutedEvent;
    private final DefinitionUtils definitionUtils;
    private CanvasCommandFactory<AbstractCanvasHandler> canvasCommandFactory;

    protected ClearSessionCommand() {
        this(null, null, null, null);
    }

    @Inject
    public ClearSessionCommand(@Any ManagedInstance<CanvasCommandFactory<AbstractCanvasHandler>> canvasCommandFactoryInstance, @Session SessionCommandManager<AbstractCanvasHandler> sessionCommandManager, Event<ClearSessionCommandExecutedEvent> commandExecutedEvent, DefinitionUtils definitionUtils) {
        super(true);
        this.canvasCommandFactoryInstance = canvasCommandFactoryInstance;
        this.sessionCommandManager = sessionCommandManager;
        this.commandExecutedEvent = commandExecutedEvent;
        this.definitionUtils = definitionUtils;
    }

    @Override
    public void bind(EditorSession session) {
        super.bind(session);
        this.canvasCommandFactory = this.loadCanvasFactory(this.canvasCommandFactoryInstance, this.definitionUtils);
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
        PortablePreconditions.checkNotNull((String)"callback", callback);
        CommandResult result = ((EditorSession)this.getSession()).getCommandManager().execute((Object)((EditorSession)this.getSession()).getCanvasHandler(), (Command)this.canvasCommandFactory.clearCanvas());
        if (!CommandUtils.isError((CommandResult)result)) {
            this.cleanSessionRegistry();
            this.commandExecutedEvent.fire((Object)new ClearSessionCommandExecutedEvent(this, (EditorSession)this.getSession()));
            callback.onSuccess();
        } else {
            callback.onError(result);
        }
    }

    private void cleanSessionRegistry() {
        LOGGER.log(Level.FINE, "Clear Session Command executed - Cleaning the session's command registry...");
        this.sessionCommandManager.getRegistry().clear();
    }
}

