/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.session.command.impl;

import java.util.Objects;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasFileExport;
import org.kie.workbench.common.stunner.core.client.service.ClientDiagramService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.event.SaveDiagramSessionCommandExecutedEvent;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.uberfire.backend.vfs.Path;

@Dependent
public class SaveDiagramSessionCommand
extends AbstractClientSessionCommand<EditorSession> {
    private static Logger LOGGER = Logger.getLogger(SaveDiagramSessionCommand.class.getName());
    private final ClientDiagramService diagramService;
    private final CanvasFileExport canvasExport;

    protected SaveDiagramSessionCommand() {
        this(null, null);
    }

    @Inject
    public SaveDiagramSessionCommand(ClientDiagramService diagramService, CanvasFileExport canvasExport) {
        super(true);
        this.diagramService = diagramService;
        this.canvasExport = canvasExport;
    }

    @Override
    public <V> void execute(ClientSessionCommand.Callback<V> callback) {
    }

    @Override
    public boolean accepts(ClientSession session) {
        return session instanceof EditorSession;
    }

    protected void onSaveDiagram(@Observes SaveDiagramSessionCommandExecutedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (Objects.isNull(this.getSession())) {
            LOGGER.severe("Session is null. Event: " + event);
            return;
        }
        Metadata diagramMetadata = this.getCanvasHandler().getDiagram().getMetadata();
        if (Objects.equals(diagramMetadata.getCanvasRootUUID(), event.getDiagramUUID())) {
            String rawSvg = this.canvasExport.exportToSvg(this.getCanvasHandler());
            this.diagramService.saveOrUpdateSvg(diagramMetadata.getPath(), rawSvg, new ServiceCallback<Path>(){

                public void onSuccess(Path path) {
                    LOGGER.info("Diagram SVG saved on " + path);
                }

                public void onError(ClientRuntimeError error) {
                    LOGGER.severe("Error saving diagram SVG " + error.getMessage());
                }
            });
        }
    }
}

