/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.shape;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.stream.StreamSupport;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.core.client.shape.ImageStrip;

@ApplicationScoped
public class ImageStripRegistry {
    private final ManagedInstance<ImageStrip> stripInstances;

    protected ImageStripRegistry() {
        this(null);
    }

    @Inject
    public ImageStripRegistry(@Any ManagedInstance<ImageStrip> stripInstances) {
        this.stripInstances = stripInstances;
    }

    public ImageStrip get(String name) {
        return StreamSupport.stream(this.stripInstances.spliterator(), false).filter(strip -> ImageStripRegistry.getName(strip).equals(name)).findAny().get();
    }

    public ImageStrip get(Class<? extends ImageStrip> stripType) {
        ManagedInstance i = this.stripInstances.select(stripType, new Annotation[0]);
        if (!i.isUnsatisfied() && !i.isAmbiguous()) {
            return (ImageStrip)i.get();
        }
        return null;
    }

    public ImageStrip[] get(Annotation ... qualifiers) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Annotation qualifier : qualifiers) {
            ManagedInstance i = this.stripInstances.select(new Annotation[]{qualifier});
            if (i.isUnsatisfied() || i.isAmbiguous()) continue;
            result.add(i.get());
        }
        return result.toArray(new ImageStrip[result.size()]);
    }

    @PreDestroy
    public void destroy() {
        this.stripInstances.destroyAll();
    }

    public static String getName(ImageStrip strip) {
        return ImageStripRegistry.getName(strip.getClass().getSuperclass());
    }

    public static String getName(Class<? extends ImageStrip> stripType) {
        return stripType.getName();
    }
}

