/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Optional;
import javax.enterprise.event.Event;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasGrid;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasDrawnEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class AbstractCanvasTest {
    private static final String PARENT_UUID = "parentUUID";
    private static final String CHILD_UUID = "childUUID";
    @Mock
    EventSourceMock<CanvasClearEvent> clearEvent;
    @Mock
    EventSourceMock<CanvasShapeAddedEvent> shapeAddedEvent;
    @Mock
    EventSourceMock<CanvasShapeRemovedEvent> shapeRemovedEvent;
    @Mock
    EventSourceMock<CanvasDrawnEvent> canvasDrawnEvent;
    @Mock
    EventSourceMock<CanvasFocusedEvent> canvasFocusEvent;
    @Mock
    Layer layer;
    @Mock
    AbstractCanvas.View canvasView;
    @Mock
    Shape parentShape;
    @Mock
    Shape childShape;
    @Mock
    ShapeView parentShapeView;
    @Mock
    ShapeView childShapeView;
    private AbstractCanvas<AbstractCanvas.View> tested;

    @Before
    public void setup() throws Exception {
        Mockito.when((Object)this.canvasView.getLayer()).thenReturn((Object)this.layer);
        Mockito.when((Object)this.parentShape.getUUID()).thenReturn((Object)PARENT_UUID);
        Mockito.when((Object)this.childShape.getUUID()).thenReturn((Object)CHILD_UUID);
        Mockito.when((Object)this.parentShape.getShapeView()).thenReturn((Object)this.parentShapeView);
        Mockito.when((Object)this.childShape.getShapeView()).thenReturn((Object)this.childShapeView);
        this.tested = new AbstractCanvasStub((Event<CanvasClearEvent>)this.clearEvent, (Event<CanvasShapeAddedEvent>)this.shapeAddedEvent, (Event<CanvasShapeRemovedEvent>)this.shapeRemovedEvent, (Event<CanvasDrawnEvent>)this.canvasDrawnEvent, (Event<CanvasFocusedEvent>)this.canvasFocusEvent, this.layer, this.canvasView);
        Assert.assertEquals((Object)this.layer, (Object)this.tested.getLayer());
    }

    @Test
    public void testShow() {
        Object panel = Mockito.mock(Object.class);
        this.tested.show(panel, 600, 400, this.layer);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).show(Matchers.eq((Object)panel), Matchers.eq((int)600), Matchers.eq((int)400), (Layer)Matchers.eq((Object)this.layer));
    }

    @Test
    public void testAddChildShape() {
        this.tested.addChildShape(this.parentShape, this.childShape);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).addChildShape((ShapeView)Matchers.eq((Object)this.parentShapeView), (ShapeView)Matchers.eq((Object)this.childShapeView));
    }

    @Test
    public void testDeleteChildShape() {
        this.tested.deleteChildShape(this.parentShape, this.childShape);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).removeChildShape((ShapeView)Matchers.eq((Object)this.parentShapeView), (ShapeView)Matchers.eq((Object)this.childShapeView));
    }

    @Test
    public void testDock() {
        this.tested.dock(this.parentShape, this.childShape);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).dock((ShapeView)Matchers.eq((Object)this.parentShapeView), (ShapeView)Matchers.eq((Object)this.childShapeView));
    }

    @Test
    public void testUndock() {
        this.tested.undock(this.parentShape, this.childShape);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).undock((ShapeView)Matchers.eq((Object)this.parentShapeView), (ShapeView)Matchers.eq((Object)this.childShapeView));
    }

    @Test
    public void testUndockToLayer() {
        this.tested.undock(this.parentShape, this.childShape);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).undock((ShapeView)Matchers.eq((Object)this.parentShapeView), (ShapeView)Matchers.eq((Object)this.childShapeView));
    }

    @Test
    public void testAddShape() {
        this.tested.addShape(this.parentShape);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).addShape((ShapeView)Matchers.eq((Object)this.parentShapeView));
        ((ShapeView)Mockito.verify((Object)this.parentShapeView, (VerificationMode)Mockito.times((int)1))).setUUID((String)Matchers.eq((Object)PARENT_UUID));
        Assert.assertEquals((long)1L, (long)this.tested.getShapes().size());
    }

    @Test
    public void testGrid() {
        CanvasGrid grid = (CanvasGrid)Mockito.mock(CanvasGrid.class);
        this.tested.setGrid(grid);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).setGrid((CanvasGrid)Matchers.eq((Object)grid));
        Assert.assertEquals((Object)grid, (Object)this.tested.getGrid());
    }

    @Test
    public void testDeleteShape() {
        this.tested.shapes.add(this.parentShape);
        this.tested.deleteShape(this.parentShape);
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).removeShape((ShapeView)Matchers.eq((Object)this.parentShapeView));
        Assert.assertTrue((boolean)this.tested.getShapes().isEmpty());
    }

    @Test
    public void testDraw() {
        this.tested.draw();
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).draw();
    }

    @Test
    public void testClear() {
        this.tested.shapes.add(this.parentShape);
        this.tested.shapes.add(this.childShape);
        this.tested.clear();
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).removeShape((ShapeView)Matchers.eq((Object)this.parentShapeView));
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).removeShape((ShapeView)Matchers.eq((Object)this.childShapeView));
        Assert.assertTrue((boolean)this.tested.getShapes().isEmpty());
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).clear();
    }

    @Test
    public void testDestroy() {
        this.tested.shapes.add(this.parentShape);
        this.tested.shapes.add(this.childShape);
        this.tested.destroy();
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).removeShape((ShapeView)Matchers.eq((Object)this.parentShapeView));
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).removeShape((ShapeView)Matchers.eq((Object)this.childShapeView));
        Assert.assertTrue((boolean)this.tested.getShapes().isEmpty());
        ((AbstractCanvas.View)Mockito.verify((Object)this.canvasView, (VerificationMode)Mockito.times((int)1))).destroy();
        ((Layer)Mockito.verify((Object)this.layer, (VerificationMode)Mockito.times((int)1))).destroy();
    }

    private class AbstractCanvasStub
    extends AbstractCanvas<AbstractCanvas.View> {
        public AbstractCanvasStub(Event<CanvasClearEvent> canvasClearEvent, Event<CanvasShapeAddedEvent> canvasShapeAddedEvent, Event<CanvasShapeRemovedEvent> canvasShapeRemovedEvent, Event<CanvasDrawnEvent> canvasDrawnEvent, Event<CanvasFocusedEvent> canvasFocusedEvent, Layer layer, AbstractCanvas.View view) {
            super(canvasClearEvent, canvasShapeAddedEvent, canvasShapeRemovedEvent, canvasDrawnEvent, canvasFocusedEvent, layer, view);
        }

        public void addControl(IsWidget controlView) {
        }

        public void deleteControl(IsWidget controlView) {
        }

        public Canvas initialize(int width, int height) {
            return this;
        }

        public Optional<Shape> getShapeAt(double x, double y) {
            return Optional.empty();
        }
    }
}

