/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommandTest;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasUndockNodeCommand;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CanvasUndockNodeCommandTest
extends AbstractCanvasCommandTest {
    private static final String P_ID = "p1";
    private static final String C_ID = "c1";
    @Mock
    private Node parent;
    @Mock
    private Node candidate;
    private CanvasUndockNodeCommand tested;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Mockito.when((Object)this.parent.getUUID()).thenReturn((Object)P_ID);
        Mockito.when((Object)this.candidate.getUUID()).thenReturn((Object)C_ID);
        this.tested = new CanvasUndockNodeCommand(this.parent, this.candidate);
    }

    @Test
    public void testExecute() {
        CommandResult result = this.tested.execute(this.canvasHandler);
        Assert.assertNotEquals((Object)CommandResult.Type.ERROR, (Object)result.getType());
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)0))).register(Matchers.anyString(), (Element)Matchers.eq((Object)this.candidate));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)0))).addChild((Element)Matchers.any(Node.class), (Element)Matchers.any(Node.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).undock((Element)Matchers.eq((Object)this.parent), (Element)Matchers.eq((Object)this.candidate));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).applyElementMutation((Element)Matchers.eq((Object)this.candidate), (MutationContext)Matchers.any(MutationContext.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).applyElementMutation((Element)Matchers.eq((Object)this.parent), (MutationContext)Matchers.any(MutationContext.class));
    }
}

