/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.TestingGraphInstanceBuilder;
import org.kie.workbench.common.stunner.core.TestingGraphMockHandler;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteCanvasNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveCanvasChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasConnectionCommand;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.impl.AbstractCompositeCommand;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.command.impl.SafeDeleteNodeCommand;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DeleteNodeCommandTest {
    private static final String SHAPE_SET_ID = "ss1";
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private AbstractCanvas canvas;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    private TestingGraphMockHandler graphHandler;
    private TestingGraphInstanceBuilder.TestGraph2 graphHolder;
    private DeleteNodeCommand tested;

    @Before
    public void setup() throws Exception {
        this.graphHandler = new TestingGraphMockHandler();
        this.graphHolder = TestingGraphInstanceBuilder.newGraph2((TestingGraphMockHandler)this.graphHandler);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.graphHandler.graphIndex);
        Mockito.when((Object)this.canvasHandler.getGraphExecutionContext()).thenReturn((Object)this.graphHandler.graphCommandExecutionContext);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graphHandler.graph);
        Mockito.when((Object)this.metadata.getDefinitionSetId()).thenReturn((Object)"defSetId");
        Mockito.when((Object)this.metadata.getShapeSetId()).thenReturn((Object)SHAPE_SET_ID);
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn((Object)this.graphHolder.parentNode.getUUID());
    }

    @Test
    public void startNodeTestGraphCommand() {
        this.tested = new DeleteNodeCommand(this.graphHolder.startNode);
        SafeDeleteNodeCommand graphCommand = (SafeDeleteNodeCommand)this.tested.newGraphCommand(this.canvasHandler);
        Assert.assertNotNull((Object)graphCommand);
        Assert.assertEquals((Object)this.graphHolder.startNode, (Object)graphCommand.getNode());
    }

    @Test
    public void startNodeTestCanvasCommands() {
        this.tested = new DeleteNodeCommand(this.graphHolder.startNode);
        CommandResult result = this.tested.allow(this.canvasHandler);
        AbstractCompositeCommand compositeCommand = (AbstractCompositeCommand)this.tested.getCommand();
        Assert.assertNotNull((Object)compositeCommand);
        Assert.assertTrue((3 == compositeCommand.size() ? 1 : 0) != 0);
        List commands = compositeCommand.getCommands();
        Assert.assertNotNull((Object)commands);
        RemoveCanvasChildCommand c2 = (RemoveCanvasChildCommand)commands.get(0);
        Assert.assertNotNull((Object)c2);
        Assert.assertEquals((Object)this.graphHolder.parentNode, (Object)c2.getParent());
        Assert.assertEquals((Object)this.graphHolder.startNode, (Object)c2.getChild());
        DeleteCanvasConnectorCommand delete1 = (DeleteCanvasConnectorCommand)commands.get(1);
        Assert.assertNotNull((Object)delete1);
        Assert.assertEquals((Object)this.graphHolder.edge1, (Object)delete1.getCandidate());
        DeleteCanvasNodeCommand c3 = (DeleteCanvasNodeCommand)commands.get(2);
        Assert.assertNotNull((Object)c3);
        Assert.assertEquals((Object)this.graphHolder.startNode, (Object)c3.getCandidate());
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)result.getType());
    }

    @Test
    public void intermediateNodeTestGraphCommand() {
        this.tested = new DeleteNodeCommand(this.graphHolder.intermNode);
        SafeDeleteNodeCommand graphCommand = (SafeDeleteNodeCommand)this.tested.newGraphCommand(this.canvasHandler);
        Assert.assertNotNull((Object)graphCommand);
        Assert.assertEquals((Object)this.graphHolder.intermNode, (Object)graphCommand.getNode());
    }

    @Test
    public void intermediateNodeTestCanvasCommands() {
        this.tested = new DeleteNodeCommand(this.graphHolder.intermNode);
        CommandResult result = this.tested.allow(this.canvasHandler);
        AbstractCompositeCommand compositeCommand = (AbstractCompositeCommand)this.tested.getCommand();
        Assert.assertNotNull((Object)compositeCommand);
        Assert.assertTrue((4 == compositeCommand.size() ? 1 : 0) != 0);
        List commands = compositeCommand.getCommands();
        Assert.assertNotNull((Object)commands);
        RemoveCanvasChildCommand c3 = (RemoveCanvasChildCommand)commands.get(0);
        Assert.assertNotNull((Object)c3);
        Assert.assertEquals((Object)this.graphHolder.parentNode, (Object)c3.getParent());
        Assert.assertEquals((Object)this.graphHolder.intermNode, (Object)c3.getChild());
        DeleteCanvasConnectorCommand delete2 = (DeleteCanvasConnectorCommand)commands.get(1);
        Assert.assertNotNull((Object)delete2);
        Assert.assertEquals((Object)this.graphHolder.edge2, (Object)delete2.getCandidate());
        SetCanvasConnectionCommand c5 = (SetCanvasConnectionCommand)commands.get(2);
        Assert.assertNotNull((Object)c5);
        Assert.assertEquals((Object)this.graphHolder.edge1, (Object)c5.getEdge());
        DeleteCanvasNodeCommand c6 = (DeleteCanvasNodeCommand)commands.get(3);
        Assert.assertNotNull((Object)c6);
        Assert.assertEquals((Object)this.graphHolder.intermNode, (Object)c6.getCandidate());
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)result.getType());
    }
}

