/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.TestingGraphInstanceBuilder;
import org.kie.workbench.common.stunner.core.TestingGraphMockHandler;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommandTest;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SetCanvasChildNodeCommandTest
extends AbstractCanvasCommandTest {
    @Mock
    private Shape connectorShape1;
    @Mock
    private Shape connectorShape2;
    @Mock
    private ShapeView connectorShapeView1;
    @Mock
    private ShapeView connectorShapeView2;
    private SetCanvasChildNodeCommand tested;
    private TestingGraphMockHandler graphTestHandler;
    private TestingGraphInstanceBuilder.TestGraph1 graph1Instance;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.graphTestHandler = new TestingGraphMockHandler();
        this.graph1Instance = TestingGraphInstanceBuilder.newGraph1((TestingGraphMockHandler)this.graphTestHandler);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graph1Instance.graph);
        Mockito.when((Object)this.graphIndex.getGraph()).thenReturn((Object)this.graph1Instance.graph);
        String edge1UUID = this.graph1Instance.edge1.getUUID();
        String edge2UUID = this.graph1Instance.edge2.getUUID();
        Mockito.when((Object)this.canvas.getShape(edge1UUID)).thenReturn((Object)this.connectorShape1);
        Mockito.when((Object)this.canvas.getShape(edge2UUID)).thenReturn((Object)this.connectorShape2);
        Mockito.when((Object)this.connectorShape1.getShapeView()).thenReturn((Object)this.connectorShapeView1);
        Mockito.when((Object)this.connectorShape2.getShapeView()).thenReturn((Object)this.connectorShapeView2);
        this.tested = new SetCanvasChildNodeCommand(this.graph1Instance.startNode, this.graph1Instance.intermNode);
    }

    @Test
    public void testExecute() {
        CommandResult result = this.tested.execute(this.canvasHandler);
        Assert.assertNotEquals((Object)CommandResult.Type.ERROR, (Object)result.getType());
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).addChild((Element)Matchers.eq((Object)this.graph1Instance.startNode), (Element)Matchers.eq((Object)this.graph1Instance.intermNode));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).applyElementMutation((Element)Matchers.eq((Object)this.graph1Instance.intermNode), (MutationContext)Matchers.any(MutationContext.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).applyElementMutation((Element)Matchers.eq((Object)this.graph1Instance.startNode), (MutationContext)Matchers.any(MutationContext.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)0))).dock((Element)Matchers.any(Node.class), (Element)Matchers.any(Node.class));
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView1, (VerificationMode)Mockito.times((int)1))).moveToTop();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView1, (VerificationMode)Mockito.never())).moveToBottom();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView1, (VerificationMode)Mockito.never())).moveUp();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView1, (VerificationMode)Mockito.never())).moveDown();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView2, (VerificationMode)Mockito.times((int)1))).moveToTop();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView2, (VerificationMode)Mockito.never())).moveToBottom();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView2, (VerificationMode)Mockito.never())).moveUp();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView2, (VerificationMode)Mockito.never())).moveDown();
    }

    @Test
    public void testSkipExecutionAsDockIsPresent() {
        Edge dockEdge = (Edge)Mockito.mock(Edge.class);
        Mockito.when((Object)dockEdge.getContent()).thenReturn((Object)new Dock());
        this.graph1Instance.intermNode.getInEdges().add(dockEdge);
        CommandResult result = this.tested.execute(this.canvasHandler);
        Assert.assertNotEquals((Object)CommandResult.Type.ERROR, (Object)result.getType());
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.never())).addChild((Element)Matchers.eq((Object)this.graph1Instance.startNode), (Element)Matchers.eq((Object)this.graph1Instance.intermNode));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.never())).applyElementMutation((Element)Matchers.eq((Object)this.graph1Instance.intermNode), (MutationContext)Matchers.any(MutationContext.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.never())).applyElementMutation((Element)Matchers.eq((Object)this.graph1Instance.startNode), (MutationContext)Matchers.any(MutationContext.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.never())).dock((Element)Matchers.any(Node.class), (Element)Matchers.any(Node.class));
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView1, (VerificationMode)Mockito.never())).moveToTop();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView1, (VerificationMode)Mockito.never())).moveToBottom();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView1, (VerificationMode)Mockito.never())).moveUp();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView1, (VerificationMode)Mockito.never())).moveDown();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView2, (VerificationMode)Mockito.never())).moveToTop();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView2, (VerificationMode)Mockito.never())).moveToBottom();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView2, (VerificationMode)Mockito.never())).moveUp();
        ((ShapeView)Mockito.verify((Object)this.connectorShapeView2, (VerificationMode)Mockito.never())).moveDown();
    }
}

