/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommandTest;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetCanvasConnectionCommand;
import org.kie.workbench.common.stunner.core.client.shape.EdgeShape;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class SetCanvasConnectionCommandTest
extends AbstractCanvasCommandTest {
    private static final String EDGE_ID = "e1";
    private static final String SOURCE_ID = "s1";
    private static final String TARGET_ID = "t1";
    @Mock
    private Edge edge;
    @Mock
    private Node source;
    @Mock
    private Node target;
    @Mock
    private EdgeShape edgeShape;
    @Mock
    private Shape sourceShape;
    @Mock
    private ShapeView sourceShapeView;
    @Mock
    private Shape targetShape;
    @Mock
    private ShapeView targetShapeView;
    private SetCanvasConnectionCommand tested;

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        Mockito.when((Object)this.edge.getUUID()).thenReturn((Object)EDGE_ID);
        Mockito.when((Object)this.source.getUUID()).thenReturn((Object)SOURCE_ID);
        Mockito.when((Object)this.target.getUUID()).thenReturn((Object)TARGET_ID);
        Mockito.when((Object)this.edge.getSourceNode()).thenReturn((Object)this.source);
        Mockito.when((Object)this.edge.getTargetNode()).thenReturn((Object)this.target);
        Mockito.when((Object)this.sourceShape.getShapeView()).thenReturn((Object)this.sourceShapeView);
        Mockito.when((Object)this.targetShape.getShapeView()).thenReturn((Object)this.targetShapeView);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)EDGE_ID))).thenReturn((Object)this.edgeShape);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)SOURCE_ID))).thenReturn((Object)this.sourceShape);
        Mockito.when((Object)this.canvas.getShape((String)Matchers.eq((Object)TARGET_ID))).thenReturn((Object)this.targetShape);
        Mockito.when((Object)this.sourceShape.getShapeView()).thenReturn((Object)this.sourceShapeView);
        this.tested = new SetCanvasConnectionCommand(this.edge);
    }

    @Test
    public void testExecute() {
        CommandResult result = this.tested.execute(this.canvasHandler);
        Assert.assertNotEquals((Object)CommandResult.Type.ERROR, (Object)result.getType());
        ((EdgeShape)Mockito.verify((Object)this.edgeShape, (VerificationMode)Mockito.times((int)1))).applyConnections((Edge)Matchers.eq((Object)this.edge), (ShapeView)Matchers.eq((Object)this.sourceShapeView), (ShapeView)Matchers.eq((Object)this.targetShapeView), (MutationContext)Matchers.any(MutationContext.class));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).notifyCanvasElementUpdated((Element)Matchers.eq((Object)this.source));
        ((AbstractCanvasHandler)Mockito.verify((Object)this.canvasHandler, (VerificationMode)Mockito.times((int)1))).notifyCanvasElementUpdated((Element)Matchers.eq((Object)this.target));
    }
}

