/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.core.TestingGraphInstanceBuilder;
import org.kie.workbench.common.stunner.core.TestingGraphMockHandler;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.DockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateDockNodeCommand;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class UpdateDockNodeCommandTest {
    public static final String LANE_UUID = "lane1";
    public static final String DOCK_UUID = "dock1";
    public static final String SHAPE_SET_ID = "shapeSetId";
    @Mock
    private AbstractCanvasHandler canvasHandler;
    @Mock
    private AbstractCanvas canvas;
    @Mock
    private Diagram diagram;
    @Mock
    private Metadata metadata;
    private TestingGraphMockHandler graphHandler;
    private TestingGraphInstanceBuilder.TestGraph2 graphHolder;
    private UpdateDockNodeCommand tested;
    private Node<View<?>, Edge> dockNode;
    private Node<View<?>, Edge> laneNode;

    @Before
    public void setup() throws Exception {
        this.graphHandler = new TestingGraphMockHandler();
        this.graphHolder = TestingGraphInstanceBuilder.newGraph2((TestingGraphMockHandler)this.graphHandler);
        this.laneNode = this.graphHandler.newViewNode(LANE_UUID, Optional.empty(), 50.0, 59.0, 500.0, 500.0);
        this.graphHandler.setChild(this.graphHolder.parentNode, this.laneNode);
        this.graphHandler.removeChild(this.graphHolder.parentNode, this.graphHolder.endNode);
        this.graphHandler.setChild(this.laneNode, this.graphHolder.endNode);
        this.dockNode = this.graphHandler.newViewNode(DOCK_UUID, Optional.empty(), 0.0, 0.0, 15.0, 15.0);
        this.graphHandler.setChild(this.graphHolder.parentNode, this.dockNode);
        Mockito.when((Object)this.canvasHandler.getDiagram()).thenReturn((Object)this.diagram);
        Mockito.when((Object)this.canvasHandler.getCanvas()).thenReturn((Object)this.canvas);
        Mockito.when((Object)this.canvasHandler.getGraphIndex()).thenReturn((Object)this.graphHandler.graphIndex);
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.diagram.getGraph()).thenReturn((Object)this.graphHandler.graph);
        Mockito.when((Object)this.metadata.getDefinitionSetId()).thenReturn((Object)"defSetId");
        Mockito.when((Object)this.metadata.getShapeSetId()).thenReturn((Object)SHAPE_SET_ID);
        Mockito.when((Object)this.metadata.getCanvasRootUUID()).thenReturn((Object)this.graphHolder.parentNode.getUUID());
        this.tested = new UpdateDockNodeCommand(this.graphHolder.endNode, this.dockNode);
    }

    @Test
    public void testDock() {
        this.graphHandler.dockTo(this.graphHolder.startNode, this.dockNode);
        this.tested = new UpdateDockNodeCommand(this.graphHolder.intermNode, this.dockNode);
        CommandResult result = this.tested.allow((Object)this.canvasHandler);
        List commands = this.tested.getCommands();
        Assert.assertTrue((2 == commands.size() ? 1 : 0) != 0);
        UnDockNodeCommand c1 = (UnDockNodeCommand)commands.get(0);
        Assert.assertNotNull((Object)c1);
        Assert.assertEquals((Object)this.graphHolder.startNode, (Object)c1.getParent());
        Assert.assertEquals(this.dockNode, (Object)c1.getCandidate());
        DockNodeCommand c2 = (DockNodeCommand)commands.get(1);
        Assert.assertNotNull((Object)c2);
        Assert.assertEquals((Object)this.graphHolder.intermNode, (Object)c2.getParent());
        Assert.assertEquals(this.dockNode, (Object)c2.getCandidate());
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)result.getType());
    }

    @Test
    public void testDockUsingDifferentParents() {
        this.tested = new UpdateDockNodeCommand(this.graphHolder.endNode, this.dockNode);
        CommandResult result = this.tested.allow((Object)this.canvasHandler);
        List commands = this.tested.getCommands();
        Assert.assertTrue((3 == commands.size() ? 1 : 0) != 0);
        RemoveChildCommand c1 = (RemoveChildCommand)commands.get(0);
        Assert.assertNotNull((Object)c1);
        Assert.assertEquals((Object)this.graphHolder.parentNode, (Object)c1.getParent());
        Assert.assertEquals(this.dockNode, (Object)c1.getCandidate());
        SetChildNodeCommand c2 = (SetChildNodeCommand)commands.get(1);
        Assert.assertNotNull((Object)c2);
        Assert.assertEquals(this.laneNode, (Object)c2.getParent());
        Assert.assertEquals(this.dockNode, (Object)c2.getCandidate());
        DockNodeCommand c6 = (DockNodeCommand)commands.get(2);
        Assert.assertNotNull((Object)c6);
        Assert.assertEquals((Object)this.graphHolder.endNode, (Object)c6.getParent());
        Assert.assertEquals(this.dockNode, (Object)c6.getCandidate());
        Assert.assertEquals((Object)CommandResult.Type.INFO, (Object)result.getType());
    }
}

